/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.Bill;
import com.ptteng.xqlease.common.service.BillService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BillServiceImpl
extends BaseDaoServiceImpl
implements BillService {
    private static final Log log = LogFactory.getLog(BillServiceImpl.class);

    public Long insert(Bill bill) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + bill));
        if (bill == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        bill.setCreateAt(Long.valueOf(currentTimeMillis));
        bill.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)bill);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + bill));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Bill> insertList(List<Bill> billList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (billList == null ? "null" : Integer.valueOf(billList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(billList)) {
            return new ArrayList<Bill>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Bill bill : billList) {
            bill.setCreateAt(Long.valueOf(currentTimeMillis));
            bill.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(billList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + billList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Bill.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Bill bill) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (bill == null ? "null" : bill.getId())));
        boolean result = false;
        if (bill == null) {
            return true;
        }
        bill.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)bill);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + bill));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + bill));
        }
        return result;
    }

    public boolean updateList(List<Bill> billList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (billList == null ? "null" : Integer.valueOf(billList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(billList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Bill bill : billList) {
            bill.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(billList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + billList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + billList.size()));
        return result;
    }

    public Bill getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Bill bill = null;
        if (id == null) {
            return bill;
        }
        try {
            bill = (Bill)this.dao.get(Bill.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return bill;
    }

    public List<Bill> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List bill = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Bill>();
        }
        try {
            bill = this.dao.getList(Bill.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (bill == null ? "null" : Integer.valueOf(bill.size()))));
        return bill;
    }

    public List<Long> getBillIdsByBillCreateStatusAndPayStatusOrderByUpdateAt(Integer billCreateStatus, Integer payStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by billCreateStatus,payStatus,start,limit  : " + billCreateStatus + " , " + payStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBillIdsByBillCreateStatusAndPayStatusOrderByUpdateAt", new Object[]{billCreateStatus, payStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by billCreateStatus,payStatus,start,limit)  : " + billCreateStatus + " , " + payStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBillIdsByBillCreateStatusAndPayStatusOrderByUpdateAt(Integer billCreateStatus, Integer payStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by billCreateStatus,payStatus  : " + billCreateStatus + " , " + payStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBillIdsByBillCreateStatusAndPayStatusOrderByUpdateAt", new Object[]{billCreateStatus, payStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by billCreateStatus,payStatus)  : " + billCreateStatus + " , " + payStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getBillIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBillIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBillIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBillIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBillIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getBillIdByBillNum(String billNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by billNum  : " + billNum));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getBillIdByBillNum", new Object[]{billNum});
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by billNum )  : " + billNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + (id == null ? "null" : id)));
        }
        return id;
    }

    public List<Long> getBillIdsByUidAndPayStatusAndBillType(Long uid, Integer payStatus, Integer billType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,payStatus,billType,start,limit  : " + uid + " , " + payStatus + " , " + billType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBillIdsByUidAndPayStatusAndBillType", new Object[]{uid, payStatus, billType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,payStatus,billType,start,limit)  : " + uid + " , " + payStatus + " , " + billType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBillIdsByUidAndPayStatus(Long uid, Integer payStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,payStatus,start,limit  : " + uid + " , " + payStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBillIdsByUidAndPayStatus", new Object[]{uid, payStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,payStatus,start,limit)  : " + uid + " , " + payStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

