/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.BillLog;
import com.ptteng.xqlease.common.service.BillLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BillLogServiceImpl
extends BaseDaoServiceImpl
implements BillLogService {
    private static final Log log = LogFactory.getLog(BillLogServiceImpl.class);

    public Long insert(BillLog billLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + billLog));
        if (billLog == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        billLog.setCreateAt(Long.valueOf(currentTimeMillis));
        billLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)billLog);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + billLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<BillLog> insertList(List<BillLog> billLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (billLogList == null ? "null" : Integer.valueOf(billLogList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(billLogList)) {
            return new ArrayList<BillLog>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BillLog billLog : billLogList) {
            billLog.setCreateAt(Long.valueOf(currentTimeMillis));
            billLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(billLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + billLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(BillLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(BillLog billLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (billLog == null ? "null" : billLog.getId())));
        boolean result = false;
        if (billLog == null) {
            return true;
        }
        billLog.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)billLog);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + billLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + billLog));
        }
        return result;
    }

    public boolean updateList(List<BillLog> billLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (billLogList == null ? "null" : Integer.valueOf(billLogList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(billLogList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (BillLog billLog : billLogList) {
            billLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(billLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + billLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + billLogList.size()));
        return result;
    }

    public BillLog getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        BillLog billLog = null;
        if (id == null) {
            return billLog;
        }
        try {
            billLog = (BillLog)this.dao.get(BillLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return billLog;
    }

    public List<BillLog> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List billLog = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<BillLog>();
        }
        try {
            billLog = this.dao.getList(BillLog.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (billLog == null ? "null" : Integer.valueOf(billLog.size()))));
        return billLog;
    }

    public List<Long> getBillLogIdsByBillLogTypeOrderByUpdateAt(Integer billLogType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by billLogType,start,limit  : " + billLogType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBillLogIdsByBillLogTypeOrderByUpdateAt", new Object[]{billLogType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by billLogType,start,limit)  : " + billLogType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBillLogIdsByBillLogTypeOrderByUpdateAt(Integer billLogType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by billLogType  : " + billLogType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBillLogIdsByBillLogTypeOrderByUpdateAt", new Object[]{billLogType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by billLogType)  : " + billLogType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getBillLogIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBillLogIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBillLogIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBillLogIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBillLogIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

