/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.qcloudsms.httpclient;

import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPMethod;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class HTTPRequest {
    public String url;
    public HTTPMethod method;
    public String body;
    public HashMap<String, String> headers;
    public HashMap<String, String> parameters;
    public int connectTimeout;
    public int requestTimeout;
    public Charset bodyCharset;

    public HTTPRequest(HTTPMethod method, String url) {
        this.method = method;
        this.url = url;
        this.headers = new HashMap();
        this.parameters = new HashMap();
        this.bodyCharset = StandardCharsets.UTF_8;
    }

    public HTTPRequest setBody(String body) {
        this.body = body;
        return this;
    }

    public HTTPRequest setBodyCharset(Charset charset) {
        this.bodyCharset = charset;
        return this;
    }

    public HTTPRequest addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HTTPRequest addQueryParameter(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public HTTPRequest addQueryParameter(String name, int value) {
        this.parameters.put(name, String.valueOf(value));
        return this;
    }

    public HTTPRequest addQueryParameter(String name, long value) {
        this.parameters.put(name, String.valueOf(value));
        return this;
    }

    public HTTPRequest setConnectionTimeout(int connectionTimeout) {
        this.connectTimeout = connectionTimeout;
        return this;
    }

    public HTTPRequest setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }
}

