/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.qcloudsms;

import com.ptteng.xqlease.common.qcloudsms.SmsBase;
import com.ptteng.xqlease.common.qcloudsms.SmsSenderUtil;
import com.ptteng.xqlease.common.qcloudsms.SmsStatusPullCallbackResult;
import com.ptteng.xqlease.common.qcloudsms.SmsStatusPullReplyResult;
import com.ptteng.xqlease.common.qcloudsms.httpclient.DefaultHTTPClient;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPClient;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPException;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPMethod;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPRequest;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class SmsStatusPuller
extends SmsBase {
    private String url = "https://yun.tim.qq.com/v5/tlssmssvr/pullstatus";

    public SmsStatusPuller(int appid, String appkey) {
        super(appid, appkey, new DefaultHTTPClient());
    }

    public SmsStatusPuller(int appid, String appkey, HTTPClient httpclient) {
        super(appid, appkey, httpclient);
    }

    private HTTPResponse pull(int type, int max) throws IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject().put("sig", (Object)SmsSenderUtil.calculateSignature(this.appkey, random, now)).put("time", now).put("type", type).put("max", max);
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(600000).setBody(body.toString());
        try {
            return this.httpclient.fetch(req);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    public SmsStatusPullCallbackResult pullCallback(int max) throws HTTPException, JSONException, IOException {
        HTTPResponse res = this.pull(0, max);
        this.handleError(res);
        return new SmsStatusPullCallbackResult().parseFromHTTPResponse(res);
    }

    public SmsStatusPullReplyResult pullReply(int max) throws HTTPException, JSONException, IOException {
        HTTPResponse res = this.pull(1, max);
        this.handleError(res);
        return new SmsStatusPullReplyResult().parseFromHTTPResponse(res);
    }
}

