/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.qcloudsms;

import com.ptteng.xqlease.common.qcloudsms.SmsBase;
import com.ptteng.xqlease.common.qcloudsms.SmsSenderUtil;
import com.ptteng.xqlease.common.qcloudsms.SmsSingleSenderResult;
import com.ptteng.xqlease.common.qcloudsms.httpclient.DefaultHTTPClient;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPClient;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPException;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPMethod;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPRequest;
import com.ptteng.xqlease.common.qcloudsms.httpclient.HTTPResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class SmsSingleSender
extends SmsBase {
    private String url = "https://yun.tim.qq.com/v5/tlssmssvr/sendsms";

    public SmsSingleSender(int appid, String appkey) {
        super(appid, appkey, new DefaultHTTPClient());
    }

    public SmsSingleSender(int appid, String appkey, HTTPClient httpclient) {
        super(appid, appkey, httpclient);
    }

    public SmsSingleSenderResult send(int type, String nationCode, String phoneNumber, String msg, String extend, String ext) throws HTTPException, JSONException, IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject().put("tel", (Object)new JSONObject().put("nationcode", (Object)nationCode).put("mobile", (Object)phoneNumber)).put("type", type).put("msg", (Object)msg).put("sig", (Object)SmsSenderUtil.calculateSignature(this.appkey, random, now, phoneNumber)).put("time", now).put("extend", (Object)(SmsSenderUtil.isNotEmpty(extend) ? extend : "")).put("ext", (Object)(SmsSenderUtil.isNotEmpty(ext) ? ext : ""));
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(60000).setBody(body.toString());
        try {
            HTTPResponse res = this.httpclient.fetch(req);
            this.handleError(res);
            return new SmsSingleSenderResult().parseFromHTTPResponse(res);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    public SmsSingleSenderResult sendWithParam(String nationCode, String phoneNumber, int templateId, ArrayList<String> params, String sign, String extend, String ext) throws HTTPException, JSONException, IOException {
        long random = SmsSenderUtil.getRandom();
        long now = SmsSenderUtil.getCurrentTime();
        JSONObject body = new JSONObject().put("tel", (Object)new JSONObject().put("nationcode", (Object)nationCode).put("mobile", (Object)phoneNumber)).put("sig", (Object)SmsSenderUtil.calculateSignature(this.appkey, random, now, phoneNumber)).put("tpl_id", templateId).put("params", params).put("sign", (Object)sign).put("time", now).put("extend", (Object)(SmsSenderUtil.isNotEmpty(extend) ? extend : "")).put("ext", (Object)(SmsSenderUtil.isNotEmpty(ext) ? ext : ""));
        HTTPRequest req = new HTTPRequest(HTTPMethod.POST, this.url).addHeader("Conetent-Type", "application/json").addQueryParameter("sdkappid", this.appid).addQueryParameter("random", random).setConnectionTimeout(60000).setRequestTimeout(60000).setBody(body.toString());
        try {
            HTTPResponse res = this.httpclient.fetch(req);
            this.handleError(res);
            return new SmsSingleSenderResult().parseFromHTTPResponse(res);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("API url has been modified, current url: " + this.url);
        }
    }

    public SmsSingleSenderResult sendWithParam(String nationCode, String phoneNumber, int templateId, String[] params, String sign, String extend, String ext) throws HTTPException, JSONException, IOException {
        return this.sendWithParam(nationCode, phoneNumber, templateId, new ArrayList<String>(Arrays.asList(params)), sign, extend, ext);
    }
}

