/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.qcloudsms;

import com.ptteng.xqlease.common.util.sha.DigestUtils;
import java.util.ArrayList;
import java.util.Random;

public class SmsSenderUtil {
    public static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getRandom() {
        return new Random(SmsSenderUtil.getCurrentTime()).nextInt(900000) + 100000;
    }

    public static String calculateSignature(String appkey, long random, long time, String phoneNumber) {
        StringBuffer buffer = new StringBuffer("appkey=").append(appkey).append("&random=").append(random).append("&time=").append(time).append("&mobile=").append(phoneNumber);
        return SmsSenderUtil.sha256(buffer.toString());
    }

    public static String calculateSignature(String appkey, long random, long time, String[] phoneNumbers) {
        StringBuffer buffer = new StringBuffer("appkey=").append(appkey).append("&random=").append(random).append("&time=").append(time).append("&mobile=");
        if (phoneNumbers.length > 0) {
            buffer.append(phoneNumbers[0]);
            for (int i = 1; i < phoneNumbers.length; ++i) {
                buffer.append(",");
                buffer.append(phoneNumbers[i]);
            }
        }
        return SmsSenderUtil.sha256(buffer.toString());
    }

    public static String calculateSignature(String appkey, long random, long time, ArrayList<String> phoneNumbers) {
        return SmsSenderUtil.calculateSignature(appkey, random, time, phoneNumbers.toArray(new String[0]));
    }

    public static String calculateSignature(String appkey, long random, long time) {
        StringBuffer buffer = new StringBuffer("appkey=").append(appkey).append("&random=").append(random).append("&time=").append(time);
        return SmsSenderUtil.sha256(buffer.toString());
    }

    public static String calculateFStatusSignature(String appkey, long random, long time, String fid) {
        StringBuffer buffer = new StringBuffer("appkey=").append(appkey).append("&random=").append(random).append("&time=").append(time).append("&fid=").append(fid);
        return SmsSenderUtil.sha256(buffer.toString());
    }

    public static String calculateAuth(String appkey, long random, long time, String fileSha1Sum) {
        StringBuffer buffer = new StringBuffer("appkey=").append(appkey).append("&random=").append(random).append("&time=").append(time).append("&content-sha1=").append(fileSha1Sum);
        return SmsSenderUtil.sha256(buffer.toString());
    }

    public static String sha1sum(String rawString) {
        return DigestUtils.sha1Hex(rawString);
    }

    public static String sha1sum(byte[] bytes) {
        return DigestUtils.sha1Hex(bytes);
    }

    public static String sha256(String rawString) {
        return DigestUtils.sha256Hex(rawString);
    }
}

