/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.admin.model.Contents;
import com.ptteng.xqlease.admin.service.ContentsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentsServiceImpl
extends BaseDaoServiceImpl
implements ContentsService {
    private static final Log log = LogFactory.getLog(ContentsServiceImpl.class);

    public Long insert(Contents contents) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + contents));
        if (contents == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        contents.setCreateAt(Long.valueOf(currentTimeMillis));
        contents.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)contents);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + contents));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Contents> insertList(List<Contents> contentsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (contentsList == null ? "null" : Integer.valueOf(contentsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(contentsList)) {
            return new ArrayList<Contents>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Contents contents : contentsList) {
            contents.setCreateAt(Long.valueOf(currentTimeMillis));
            contents.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(contentsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + contentsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Contents.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Contents contents) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (contents == null ? "null" : contents.getId())));
        boolean result = false;
        if (contents == null) {
            return true;
        }
        contents.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)contents);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + contents));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + contents));
        }
        return result;
    }

    public boolean updateList(List<Contents> contentsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (contentsList == null ? "null" : Integer.valueOf(contentsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(contentsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Contents contents : contentsList) {
            contents.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(contentsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + contentsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + contentsList.size()));
        return result;
    }

    public Contents getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get getObjectById : " + id));
        Contents contents = null;
        if (id == null) {
            return contents;
        }
        try {
            contents = (Contents)this.dao.get(Contents.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return contents;
    }

    public List<Contents> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List contents = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Contents>();
        }
        try {
            contents = this.dao.getList(Contents.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (contents == null ? "null" : Integer.valueOf(contents.size()))));
        return contents;
    }

    public List<Long> getContentsIdsByTypeAndStatusOrderByLevel(Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,status,start,limit  : " + type + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getContentsIdsByTypeAndStatusOrderByLevel", new Object[]{type, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,status,start,limit)  : " + type + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getContentsIdsByTypeAndStatusOrderByPublishAt(Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,status,start,limit  : " + type + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getContentsIdsByTypeAndStatusOrderByPublishAt", new Object[]{type, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,status,start,limit)  : " + type + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countContentsIdsByTypeAndStatusOrderByLevel(Integer type, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type,status  : " + type + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getContentsIdsByTypeAndStatusOrderByLevel", new Object[]{type, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type,status)  : " + type + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countContentsIdsByTypeAndStatusOrderByPublishAt(Integer type, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type,status  : " + type + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getContentsIdsByTypeAndStatusOrderByPublishAt", new Object[]{type, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type,status)  : " + type + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getContentsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getContentsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countContentsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getContentsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getContentsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

