package com.ptteng.studyabroad.controller;

import com.ptteng.studyabroad.admin.model.ReserveUser;
import com.ptteng.studyabroad.admin.service.ReserveUserService;
import com.ptteng.studyabroad.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * ReserveUser  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ReserveUserController {
	private static final Log log = LogFactory.getLog(ReserveUserController.class);

	@Autowired
	private ReserveUserService reserveUserService;


	/**
	 * 新增预约用户
	 * @param request
	 * @param response
	 * @param model
	 * @param reserveUser
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/reserve/user", method = RequestMethod.POST)
	public String addReserveUserJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @RequestBody ReserveUser reserveUser) throws Exception {
		
		log.info("add reserveUser is : " + reserveUser);

		if (DataUtils.isNullOrEmpty(reserveUser.getName())) {
			log.error("用户名有误或为空！");
			model.addAttribute("code", -5007);
			return "common/fail";
		}
		if (DataUtils.isNullOrEmpty(reserveUser.getMobile())) {
			log.error("手机号有误或为空！");
			model.addAttribute("code", -5009);
			return "common/fail";
		}

		Map<String, Object> param = null;

		Map<String, Object> mobileParam = null;

		List<Long> reserveUserIdList = null;

		List<Long> reserveUserMobileIdList = null;

		try {
//			param = DynamicUtil.getReserveUser(reserveUser.getName());
//			reserveUserIdList = reserveUserService.getIdsByDynamicCondition(ReserveUser.class,param,0, Integer.MAX_VALUE);
//			if (DataUtils.isNullOrEmpty(reserveUserIdList)) {
//				log.error("get reserveUserIdList is null！");
//				model.addAttribute("code", -5019);
//				return "common/fail";
//			}
//			log.info("get reserveUserIdList is :" + reserveUserIdList);
//
//			//如果数据库中已经有name了，返回结果不是0
//			if (reserveUserIdList.size() != 0) {
//				model.addAttribute("code",-5019);
//				return "common/fail";
//			}

			mobileParam = DynamicUtil.getReserveUserMobile(reserveUser.getMobile());
			reserveUserMobileIdList = reserveUserService.getIdsByDynamicCondition(ReserveUser.class,mobileParam,0, Integer.MAX_VALUE);
			log.info("get reserveUserMobileIdList is :" + reserveUserMobileIdList);

			if (reserveUserMobileIdList.size() != 0) {
				model.addAttribute("code",-5021);
				return "common/fail";
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add reserveUser error ");
			model.addAttribute("code", -100000);
		}


		try {
			reserveUser.setId(null);

			Long id = reserveUserService.insert(reserveUser);
			log.info("insert reserveUser id is : " + id);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add reserveUser error ");
			model.addAttribute("code", -100000);
		}

		return "/data/json";
	}


	
	
	
}

