package com.ptteng.studyabroad.controller;

import com.ptteng.studyabroad.admin.model.Article;
import com.ptteng.studyabroad.admin.service.ArticleService;
import com.ptteng.studyabroad.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Article  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ArticleController {
	private static final Log log = LogFactory.getLog(ArticleController.class);

	@Autowired
	private ArticleService articleService;





	/**
	 * 1.搜索列表
	 * @param request
	 * @param response
	 * @param model
	 * @param title
	 * @param author
	 * @param createBy
	 * @param status
	 * @param startAt
	 * @param endAt
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/article/search", method = RequestMethod.GET)
	public String getarticleList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model,
								 String title,String author,String createBy,
								 Integer status,Long startAt,Long endAt,
								 Integer page, Integer size
	) throws Exception {


		log.info("get param is = page is : " + page + " size is : " + size + " title is : " + title + " author is : " + author +
				" createBy is : " + createBy + " status is : " + status + " startAt is : " + startAt + " endAt is : " + endAt);

		if (page == null || page <= 0) {
			page = 1;
		}
		if (size == null || size <= 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<Long> articelIdList = null;

		List<Long> count = null;

		List<Article> articleList = null;

		Map<String, Object> param = null;

		param = DynamicUtil.getArticleList(title, author, createBy, status, startAt, endAt);

		try {


			articelIdList = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
			if (DataUtils.isNullOrEmpty(articelIdList)) {
				log.error("get articleIdList is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get articleIdList is : " + articelIdList);

			count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
			if (DataUtils.isNullOrEmpty(count)) {
				log.error("get count is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get count is : " + count);

			articleList = articleService.getObjectsByIds(articelIdList);
			if (DataUtils.isNullOrEmpty(articleList)) {
				log.error("get articleList is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get articleList.size is : " + articleList.size());

			model.addAttribute("code", "0");
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", count.size());
			model.addAttribute("articleList", articleList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get articleList error ");
			model.addAttribute("code", -100000);
			return "common/fail";
		}





		return "/studyabroad-home-service/article/json/articleListJson";
	}

	/**
	 * 2、详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/article/{id}", method = RequestMethod.GET)
	public String getArticleJson(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {
		if (DataUtils.isNullOrEmpty(id)) {
			log.error("get id is null！");
			model.addAttribute("code", -1000);
			return "common/fail";
		}
		log.info("get Article  id is : " + id);
		try {
			Article article = articleService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(article)) {
				log.error("get article is null！");
				model.addAttribute("code", -1000);
				return "common/fail";
			}
			log.info("get article  is : " + article);

			model.addAttribute("code", 0);

			model.addAttribute("article", article);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/studyabroad-home-service/article/json/articleDetailJson";
	}





}

