-- ----------------------------
-- Table structure for `role`
-- ----------------------------
-- DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `name` varchar(20)    COMMENT '角色名字',  
    `status` varchar(20)    COMMENT '状态',  
    `permissions` varchar(200)    COMMENT '权限',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '更新时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `manager`
-- ----------------------------
-- DROP TABLE IF EXISTS `manager`;
CREATE TABLE `manager` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `mobile` varchar(20)    COMMENT '手机号码',  
    `rid` bigint    COMMENT '角色id',  
    `pwd` varchar(20)    COMMENT '密码',  
    `name` varchar(20)    COMMENT '用户名',  
    `status` varchar(20)    COMMENT '状态',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '更新时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `module`
-- ----------------------------
-- DROP TABLE IF EXISTS `module`;
CREATE TABLE `module` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `name` varchar(20)    COMMENT '模块名称',  
    `pid` bigint    COMMENT '父模块id',  
    `type` varchar(20)    COMMENT '模块类型',  
    `menu_id` bigint    COMMENT '菜单id',  
    `icon` varchar(50)    COMMENT '图标',  
    `level` int(2)    COMMENT '等级',  
    `url` varchar(100)    COMMENT '模块url',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '更新时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `role_module`
-- ----------------------------
-- DROP TABLE IF EXISTS `role_module`;
CREATE TABLE `role_module` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `rid` bigint    COMMENT '角色id',  
    `module_id` bigint    COMMENT '模块id',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '更新时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `article`
-- ----------------------------
-- DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `title` varchar(20) NOT NULL   COMMENT '标题',  
    `author` varchar(20)    COMMENT '作者',  
    `url` varchar(100)    COMMENT '跳转链接',  
    `img` varchar(100)    COMMENT '配图链接',  
    `summary` varchar(2000)    COMMENT '摘要',  
    `content` varchar(2000)    COMMENT '内容',  
    `status` int(2)    COMMENT '上下线状态',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '修改时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `train`
-- ----------------------------
-- DROP TABLE IF EXISTS `train`;
CREATE TABLE `train` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `language` int(2)    COMMENT '语言类型',  
    `classType` int(2)    COMMENT '班级类型',  
    `teacherType` int(2)    COMMENT '教师类型',  
    `startAt` bigint    COMMENT '上课开始时间',  
    `endAt` bigint    COMMENT '上课结束时间',  
    `status` int(2)    COMMENT '上下线状态',  
    `week` int(2)    COMMENT '上课周期',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '更新时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `reserve_user`
-- ----------------------------
-- DROP TABLE IF EXISTS `reserve_user`;
CREATE TABLE `reserve_user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增id',  
    `name` varchar(20) NOT NULL   COMMENT '预约用户',  
    `mobile` varchar(20) NOT NULL   COMMENT '手机号',  
    `createAt` bigint    COMMENT '创建时间',  
    `updateAt` bigint    COMMENT '更新时间',  
    `createBy` bigint    COMMENT '创建人',  
    `updateBy` bigint    COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





