/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.studyabroad.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.studyabroad.admin.model.Train;
import com.ptteng.studyabroad.admin.service.TrainService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrainServiceImpl
extends BaseDaoServiceImpl
implements TrainService {
    private static final Log log = LogFactory.getLog(TrainServiceImpl.class);

    public Long insert(Train train) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + train));
        if (train == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        train.setCreateAt(Long.valueOf(currentTimeMillis));
        train.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)train);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + train));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Train> insertList(List<Train> trainList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (trainList == null ? "null" : Integer.valueOf(trainList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(trainList)) {
            return new ArrayList<Train>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Train train : trainList) {
            train.setCreateAt(Long.valueOf(currentTimeMillis));
            train.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(trainList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + trainList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Train.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Train train) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (train == null ? "null" : train.getId())));
        boolean result = false;
        if (train == null) {
            return true;
        }
        train.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)train);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + train));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + train));
        }
        return result;
    }

    public boolean updateList(List<Train> trainList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (trainList == null ? "null" : Integer.valueOf(trainList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(trainList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Train train : trainList) {
            train.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(trainList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + trainList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + trainList.size()));
        return result;
    }

    public Train getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Train train = null;
        if (id == null) {
            return train;
        }
        try {
            train = (Train)this.dao.get(Train.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return train;
    }

    public List<Train> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List train = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Train>();
        }
        try {
            train = this.dao.getList(Train.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (train == null ? "null" : Integer.valueOf(train.size()))));
        return train;
    }

    public List<Long> getTrainIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTrainIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTrainIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTrainIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTrainIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

