package com.ptteng.score.home.util;


import com.ptteng.score.home.model.Staff;
import com.ptteng.score.home.model.Tenant;
import com.ptteng.score.home.service.StaffService;
import com.ptteng.score.home.service.TenantService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;

/**
 * @author shun
 * @date 2017/6/28
 */


public class LoginInterceptor implements HandlerInterceptor {
    private static final Log log = LogFactory.getLog(LoginInterceptor.class);

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private StaffService staffService;

    @Autowired
    private TenantService tenantService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {

        //把所有的请求参数打出来
        log.info(" request uri: " + request.getRequestURI());
        log.info("request token " + request.getHeader("token"));
        Enumeration<String> names = request.getParameterNames();
        log.info("=========================================" + request.getParameter("token"));
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String value = request.getParameter(name);
            log.info(" Parameter  name : " + name + " value : " + value);
        }


        Long userId = cookieUtil.getID(request);
        log.info("uid is " + userId);
        if (userId == null) {
            return wrongUser(response, "-2");
        }

        log.info("get uid  from cookie is " + userId);
        //前台登陆拦截，用户为员工，且企业账号不为禁用
        Staff user = staffService.getObjectById(userId);
        if (user == null) {
            return wrongUser(response, "-2");
        } else {
            Tenant tenant = tenantService.getObjectById(user.getTenantId());
            if (DataUtils.isNullOrEmpty(tenant)) {
                log.info("get tenant error ");
                return wrongUser(response, "-2");
            } else if (tenant.getStatus().equals(Tenant.TYPE_PROBATION)) {
                log.error("tenant status id probation");
                return wrongUser(response, "-3");
            } else {
                log.info("get user " + user);
                request.setAttribute("user", user);
                return true;
            }
        }
    }

    private boolean wrongUser(HttpServletResponse response, String token) throws IOException {

        response.sendRedirect("/a/wrong/" + token);
        return false;

    }


    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {

    }
}