package com.ptteng.score.home.controller;

import com.gemantic.common.util.MyListUtil;
import com.google.gson.reflect.TypeToken;
import com.ptteng.score.home.constant.ConstantItem;
import com.ptteng.score.home.model.*;
import com.ptteng.score.home.responseStructure.TimeScoreLogCatagory;
import com.ptteng.score.home.service.*;
import com.ptteng.score.home.util.*;
import com.ptteng.score.home.vo.Comment;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.*;

/**
 * ScoreLog  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ScoreLogController {
    private static final Log log = LogFactory.getLog(ScoreLogController.class);

    @Autowired
    private ScoreLogService scoreLogService;
    @Autowired
    private StaffService staffService;
    @Autowired
    private RewardLogService rewardLogService;
    @Autowired
    private StaffPhilosophyRelationService staffPhilosophyRelationService;
    @Autowired
    private PhilosophyService philosophyService;
    @Autowired
    private EnterpriseApprovalService enterpriseApprovalService;
    @Autowired
    private EnterpriseLogService enterpriseLogService;
    @Autowired
    private ApproveLogService approveLogService;
    @Autowired
    private AttendanceLogService attendanceLogService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ManagerService managerService;

    /**
     * @param
     * @return
     */
    /**
     * @param request
     * @param response
     * @param model
     * @param id
     * @Author hfismyangel@163.com
     * @Description:个人中心积分日志列表
     * @Date: 16:10 2017/10/3
     */
    @RequestMapping(value = "/a/u/detail/scoreLog", method = RequestMethod.GET)
    public String getscoreLogList(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Long id) throws Exception {


        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get id is: " + id);
        List<ScoreLog> scoreLogList;
        try {

            Staff loginUser = ScoreUserUtil.getLoginUser(request);
            //List<Long> scoreLogIds = scoreLogService.getScoreLogIds(0, Integer.MAX_VALUE);

            Map<String, Object> scoreLogParams =  DynamicSQLUtil.searchSinglenewScoreLo(null, null, loginUser.getTenantId());
            List<Long> scoreLogIds = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, scoreLogParams, 0, Integer.MAX_VALUE);


            log.info("get scoreLogIds is: " + scoreLogIds);
            scoreLogList = scoreLogService.getObjectsByIds(scoreLogIds);
            log.info("get scoreLogList.size is: " + scoreLogList.size());
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get philosophy error 4");
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        List<ScoreLog> currentStaffScoreLogList = new ArrayList<>();
        for (ScoreLog scoreLog : scoreLogList) {

            if (id.equals(scoreLog.getStaffId())) {
                currentStaffScoreLogList.add(scoreLog);
            }
        }


        // Map<Long, ScoreLog> staffIdLogMap = MyListUtil.convert2ListMap(ScoreLog.class.getDeclaredField("staffId"), scoreLogList);
        log.info("===============>>" + currentStaffScoreLogList.size());

        List<TimeScoreLogCatagory> logCatagories = new ArrayList<>();


        Set<String> strings = new HashSet<>();
        for (ScoreLog scoreLog2 : currentStaffScoreLogList) {
            strings.add(DateUtil.formatTime(scoreLog2.getCreateAt().toString()));
        }

        log.info("=============count size>>" + strings.size());
        for (String str : strings) {
            TimeScoreLogCatagory timeScoreLogCatagory1 = new TimeScoreLogCatagory();
            timeScoreLogCatagory1.setFormatTime(str);
            List<ScoreLog> logCatagories1 = new ArrayList<>();
            for (ScoreLog scoreLog3 : currentStaffScoreLogList) {
                String format = DateUtil.formatTime(scoreLog3.getCreateAt().toString());
                if (str.equals(format)) {
                    logCatagories1.add(scoreLog3);
                }
            }
            timeScoreLogCatagory1.setScoreLogList(logCatagories1);
            logCatagories.add(timeScoreLogCatagory1);
        }
        Collections.reverse(logCatagories);
        model.addAttribute("code", 0);
        model.addAttribute("categoryList", logCatagories);
        return "json/othersJsp/json/scoreLogListByGroup";
    }

    /**
     * @param request
     * @param response
     * @param model
     * @param
     * @Author hfismyangel@163.com
     * @Description:积分明细列表1（按时间统计积分情况）
     * @Date: 16:10 2017/10/3
     */
    @RequestMapping(value = "/a/u/detail/scoreLogs", method = RequestMethod.GET)
    public String getscoreLog(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Integer time) throws Exception {

        if (DataUtils.isNullOrEmpty(time)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get time is: " + time);
        Long startTime = 0L;
        switch (time) {
            case 0:
                startTime = DateUtil.timeUtil(ConstantItem.ZERO);
                break;
            case 1:
                startTime = DateUtil.getCurrentMonthLastDay();
                break;
            case 2:
                startTime = DateUtil.getQuarterByMonth(false);
                break;
            case 3:
                startTime = 0L;
                break;
            default:
        }
        List<ScoreLog> scoreLogList;
        Staff staff;
        try {
            Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
            log.info("get adminId is: " + adminId);
            staff = staffService.getObjectById(adminId);
            log.info("get staff is: " + staff.getId());
            Long endTime = System.currentTimeMillis();
            Map<String, Object> map = DynamicSQLUtil.seareLo(startTime, endTime, adminId);
            List<Long> count = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, map, ConstantItem.ZERO, Integer.MAX_VALUE);
            log.info("get count is: " + count);
            scoreLogList = scoreLogService.getObjectsByIds(count);
            log.info("get scoreLogList.size is: " + scoreLogList.size());
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get philosophy error 5");
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        model.addAttribute("code", 0);
        model.addAttribute("scoreLogList", scoreLogList);
        model.addAttribute("staff", staff);
        return "json/othersJsp/json/scoreLogListJsons";
    }

    /**
     * @param request
     * @param response
     * @param model
     * @Author hfismyangel@163.com
     * @Description:积分明细列表2（积分加减情况）
     * @Date: 16:10 2017/10/3
     */
    @RequestMapping(value = "/a/u/detail/scoreLogs/addSub", method = RequestMethod.GET)
    public String ge(HttpServletRequest request,
                     HttpServletResponse response, ModelMap model, Integer type) throws Exception {

        if (DataUtils.isNullOrEmpty(type)) {
            log.info("get type is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get type is: " + type);
        List<ScoreLog> scoreLogList;
        try {
            Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
            log.info("get adminId is: " + adminId);
            Map<String, Object> map = DynamicSQLUtil.searchSingleScoreLog(adminId);
            List<Long> count = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, map, 0, Integer.MAX_VALUE);
            log.info("get count is: " + count);

            scoreLogList = scoreLogService.getObjectsByIds(count);
            log.info("get scoreLogList.size is: " + scoreLogList.size());
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get philosophy error 6");
            model.addAttribute("code", -100000);
            return "common/fail";
        }

        List<ScoreLog> addList = new ArrayList<>();
        List<ScoreLog> subList = new ArrayList<>();

        for (ScoreLog scoreLog : scoreLogList) {
            if ("+".equals(scoreLog.getScoreChange().substring(ConstantItem.ZERO, ConstantItem.ONE))) {
                addList.add(scoreLog);
            } else {
                subList.add(scoreLog);
            }
        }
        if (type == 1) {
            model.addAttribute("code", 0);
            model.addAttribute("scoreLogList", addList);
            return "json/scoreLog/json/scoreLogListJson";
        } else {
            model.addAttribute("code", 0);
            model.addAttribute("scoreLogList", subList);
            return "json/scoreLog/json/scoreLogListJson";
        }

    }

    /**
     * @param request
     * @param response
     * @param model
     * @Author hfismyangel@163.com
     * @Description:首页全部积分日志列表
     * @Date: 16:10 2017/10/3
     */
    @RequestMapping(value = "/a/u/detail/allScoreLogs", method = RequestMethod.GET)
    public String getscoreog(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, Long startTime) throws Exception {


        if (null == startTime) {
            startTime = ConstantItem.ZERO_ID;
        }
        log.info("get startTime is: " + startTime);
        List<Staff> staffList;
        List<ScoreLog> scoreLogList;
        Long endTime = startTime + 24 * 60 * 60 * 1000L;
        try {

            //获取登录用户
            Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, com.qding.common.util.http.cookie.CookieUtil.USER_ID));
            Staff loginUser = staffService.getObjectById(adminId);


            //获取租户id
            Long tenantId = loginUser.getTenantId();

            Map<String, Object> map = DynamicSQLUtil.searchSinglenewScoreLo(startTime, endTime, tenantId);
            List<Long> count = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, map, 0, Integer.MAX_VALUE);
            log.info("get count is: " + count);
            scoreLogList = scoreLogService.getObjectsByIds(count);
            log.info("get scoreLogList.size is: " + scoreLogList.size());
            List<Long> staffIds = staffService.getStaffIds(ConstantItem.ZERO, Integer.MAX_VALUE);
            log.info("get staffIds is: " + staffIds);
            staffList = staffService.getObjectsByIds(staffIds);
            log.info("get staffList.size is: " + staffList.size());
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get philosophy error 7");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        List<Map<String, Object>> list = new ArrayList<>();
        log.info(scoreLogList.size());

        Map staffId_class = MyListUtil.convert2Map(Staff.class.getDeclaredField("id"), staffList);

        model.addAttribute("code", 0);
        model.addAttribute("staffId_class", staffId_class);
        model.addAttribute("scoreLogList", scoreLogList);
        return "json/othersJsp/json/scoreLogListJson";
    }

    /**
     * @param request
     * @param response
     * @param model
     * @param id
     * @Author hfismyangel@163.com
     * @Description:个人积分日志详情(加/减分)
     * @Date: 16:10 2017/10/3
     */
    @RequestMapping(value = "/a/u/personalLogDetail", method = RequestMethod.GET)
    public String getscoreLogAddOrSub(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long id, Integer status) throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get id is: " + id);
        if (DataUtils.isNullOrEmpty(status)) {
            log.info("get status is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get status is: " + id);
        List<ScoreLog> scoreLogList;
        try {
            Map<String, Object> map = DynamicSQLUtil.searchMyScoreLog(id);
            List<Long> count = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, map, 0, Integer.MAX_VALUE);
            log.info("get count is: " + count);

            scoreLogList = scoreLogService.getObjectsByIds(count);
            log.info("get scoreLogList.size is: " + scoreLogList.size());
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get philosophy error 8");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        List<ScoreLog> logs = new ArrayList<>();
        if (status == ConstantItem.ONE) {
            for (ScoreLog scoreLog : scoreLogList) {
                if (scoreLog.getScoreChange().substring(ConstantItem.ZERO, ConstantItem.ONE).equals("+")) {
                    logs.add(scoreLog);
                } else if (!scoreLog.getScoreChange().substring(ConstantItem.ZERO, ConstantItem.ONE).equals("-")) {
                    logs.add(scoreLog);
                }
            }
        } else {
            for (ScoreLog scoreLog : scoreLogList) {
                if (scoreLog.getScoreChange().substring(ConstantItem.ZERO, ConstantItem.ONE).equals("-")) {
                    logs.add(scoreLog);
                }
            }
        }
        model.addAttribute("code", 0);
        model.addAttribute("scoreLogList", logs);
        return "json/scoreLog/json/scoreLogListJson";
    }

    @RequestMapping(value = "/a/u/detail/detailScorelog", method = RequestMethod.GET)
    public String getdetailScorelog(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long id) throws Exception {
        /**
         *@Author hfismyangel@163.com
         *@Description:个人积分日志详情
         *@Date: 16:10 2017/10/3
         * @param request
         * @param response
         * @param model
         * @param id
         */
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get id is: " + id);
        ScoreLog scoreLog = null;
        try {
            scoreLog = scoreLogService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(scoreLog)) {
                log.info("get scoreLog is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get scoreLog is: " + scoreLog);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get person score log error ");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
        log.info("get scoreLog is: " + scoreLog);
        model.addAttribute("code", 0);
        model.addAttribute("scoreLog", scoreLog);
        return "json/scoreLog/json/scoreLogDetailJson";
    }

    /**
     * @param request
     * @param response
     * @param model
     * @param id
     * @Author hfismyangel@163.com
     * @Description:跳转前端控制器 0发布日志被点赞
     * 1阅读企业文档
     * 2获取领导表扬
     * 3审批获得通过
     * @Date: 16:10 2017/10/3
     */
    //,produces = "application/json; charset=utf-8"去掉后返回数据会有？？？
    @RequestMapping(value = "/a/u/dispatcher", method = RequestMethod.GET, produces = "application/json; charset=utf-8")
    public String disPatcherSwitch(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Integer typeId, Long id) throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get id is: " + id);
        if (DataUtils.isNullOrEmpty(typeId)) {
            log.info("get typeId is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get typeId is: " + id);
        HttpClientUtil httpClientUtil = new HttpClientUtil();
        String result = "";
        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
        switch (typeId) {
            case 0:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                try {
                    EnterpriseApproval enterpriseApproval = enterpriseApprovalService.getObjectById(id);
                    if (null == enterpriseApproval) {
                        model.addAttribute("code", -1000);
                        return "common/fail";
                    }
                    Staff staff = staffService.getObjectById(enterpriseApproval.getApplyId());
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("enterpriseApproval", enterpriseApproval);
                    map1.put("staff", staff);

                    log.info("get map1 is: " + map1);
                    model.addAttribute("code", 0);
                    model.addAttribute("enterpriseApproval", map1);
                    return "json/enterpriseApproval/json/enterpriseApprovalListJsons";

                } catch (Exception e) {
                    e.printStackTrace();
                    log.error(e.getMessage());
                    log.error("get enterpriseApproval error ");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }

            case 1:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                try {
                    EnterpriseApproval enterpriseApproval = enterpriseApprovalService.getObjectById(id);
                    if (null == enterpriseApproval) {
                        model.addAttribute("code", -1000);
                        return "common/fail";
                    }
                    Staff staff = staffService.getObjectById(enterpriseApproval.getApplyId());
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("enterpriseApproval", enterpriseApproval);
                    map1.put("staff", staff);

                    log.info("get map1 is: " + map1);
                    model.addAttribute("code", 0);
                    model.addAttribute("enterpriseApproval", map1);
                    return "json/enterpriseApproval/json/enterpriseApprovalListJsons";

                } catch (Exception e) {
                    e.printStackTrace();
                    log.error(e.getMessage());
                    log.error("get enterpriseApproval error ");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }
            case 2:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                try {
                    EnterpriseApproval enterpriseApproval = enterpriseApprovalService.getObjectById(id);
                    if (null == enterpriseApproval) {
                        model.addAttribute("code", -1002);
                        return "common/fail";
                    }
                    Staff staff = staffService.getObjectById(enterpriseApproval.getApplyId());
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("enterpriseApproval", enterpriseApproval);
                    map1.put("staff", staff);

                    log.info("get map1 is: " + map1);
                    model.addAttribute("code", 0);
                    model.addAttribute("enterpriseApproval", map1);
                    return "json/enterpriseApproval/json/enterpriseApprovalListJsons";

                } catch (Exception e) {
                    e.printStackTrace();
                    log.error(e.getMessage());
                    log.error("get enterpriseApproval error ");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }
            case 3:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                try {
                    EnterpriseApproval enterpriseApproval = enterpriseApprovalService.getObjectById(id);
                    if (null == enterpriseApproval) {
                        model.addAttribute("code", -1000);
                        return "common/fail";
                    }
                    Staff staff = staffService.getObjectById(enterpriseApproval.getApplyId());
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("enterpriseApproval", enterpriseApproval);
                    map1.put("staff", staff);

                    log.info("get map1 is: " + map1);
                    model.addAttribute("code", 0);
                    model.addAttribute("enterpriseApproval", map1);
                    return "json/enterpriseApproval/json/enterpriseApprovalListJsons";

                } catch (Exception e) {
                    e.printStackTrace();
                    log.error(e.getMessage());
                    log.error("get enterpriseApproval error ");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }
            case 7:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                try {
                    EnterpriseApproval enterpriseApproval = enterpriseApprovalService.getObjectById(id);
                    if (null == enterpriseApproval) {
                        model.addAttribute("code", -1000);
                        return "common/fail";
                    }
                    Staff staff = staffService.getObjectById(enterpriseApproval.getApplyId());
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("enterpriseApproval", enterpriseApproval);
                    map1.put("staff", staff);

                    log.info("get map1 is: " + map1);
                    model.addAttribute("code", 0);
                    model.addAttribute("enterpriseApproval", map1);
                    return "json/enterpriseApproval/json/enterpriseApprovalListJsons";

                } catch (Exception e) {
                    e.printStackTrace();
                    log.error(e.getMessage());
                    log.error("get enterpriseApproval error ");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }
            case 4:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);

                Map<String, Object> param = null;

                Integer isPraise = null;
                try {

                    Long staffId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));


                    param = DynamicSQLUtil.getPraiseIdList(id, staffId);
                    List<Long> longList = approveLogService.getIdsByDynamicCondition(ApproveLog.class, param, 0, Integer.MAX_VALUE);
                    if (longList.size() > 0) {
                        isPraise = ConstantItem.ONE;
                    } else {
                        isPraise = ConstantItem.ZERO;
                    }


                    EnterpriseLog enterpriseLog = enterpriseLogService.getObjectById(id);
                    Type type = new TypeToken<List<Comment>>() {
                    }.getType();
                    String comment = enterpriseLog.getComment();
                    List<Comment> comments = GsonUtil.getUnerializeNullsGson().fromJson(comment, type);
                    log.info("get comments is: " + comment);


                    Type type1 = new TypeToken<List<String>>() {
                    }.getType();
                    String praise = enterpriseLog.getPraise();
                    List<String> praises = GsonUtil.getUnerializeNullsGson().fromJson(praise, type1);
                    log.info("get praises is: " + praises);

                    log.info("get workLog id is: " + enterpriseLog.getStaffId());

                    Staff staff = staffService.getObjectById(enterpriseLog.getStaffId());
                    log.info("get staffId is: " + staff.getId());


                    Map<String, Object> data = new HashMap<>();
                    data.put("staff", staff);
                    data.put("enterpriseLog", enterpriseLog);
                    data.put("praise", praises);
                    data.put("commentList", comments);
                    data.put("isPraise", isPraise);
                    log.info("get data is: " + data);


                    model.addAttribute("code", 0);
                    model.addAttribute("data", data);
                    return "json/enterpriseLog/json/enterpriseLogDetailJson";
                } catch (Exception e) {


                    e.printStackTrace();
                    log.error(e.getMessage());
                    log.error("get enterpriseLog error 2");
                    model.addAttribute("code", -10000);
                    return "common/fail";
                }
            case 5:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                if (DataUtils.isNullOrEmpty(adminId)) {
                    log.info("get adminId is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get adminId is: " + id);
                try {
                    Map<String, Object> map = DynamicSQLUtil.searelation(adminId, id);
                    List<Long> count = staffPhilosophyRelationService.getIdsByDynamicCondition(StaffPhilosophyRelation.class, map, 0, Integer.MAX_VALUE);
                    log.info("get count is: " + count);

                    Philosophy philosophy = philosophyService.getObjectById(id);
                    if (DataUtils.isNullOrEmpty(philosophy)) {
                        log.info("get philosophy is null！");
                        model.addAttribute("code", -1000);
                        return "common/fail";
                    }
                    log.info("get philosophy is: " + id);
                    if (count == null || count.size() == ConstantItem.ZERO) {
                        philosophy.setArticleStatus(ConstantItem.ZERO);
                    } else {
                        philosophy.setArticleStatus(ConstantItem.ONE);
                    }
                    model.addAttribute("code", 0);
                    model.addAttribute("philosophy", philosophy);
                    return "json/philosophy/json/philosophyDetailJson";
                } catch (Throwable t) {
                    t.printStackTrace();
                    log.error(t.getMessage());
                    log.error("get philosophy error 9");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }
            case 6:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }
                log.info("get id is: " + id);
                try {
                    RewardLog rewardLog = rewardLogService.getObjectById(id);
                    log.info("get rewardLog is: " + rewardLog.getId());

                    if (DataUtils.isNullOrEmpty(rewardLog.getStaffId())) {
                        log.info("get staffId is null！");
                        model.addAttribute("code", -1000);
                        return "common/fail";
                    }
                    log.info("get staffId is: " + rewardLog.getStaffId());

                    Long staffId = rewardLog.getStaffId();
                    Staff staff = staffService.getObjectById(staffId);

                    log.info("get staffId is: " + staff.getId());

                    model.addAttribute("code", 0);
                    model.addAttribute("staff", staff);
                    model.addAttribute("rewardLog", rewardLog);
                    return "json/rewardLog/json/rewardLogDetailJson";

                } catch (Exception t) {
                    t.printStackTrace();
                    log.error(t.getMessage());
                    log.error("get ranking error ");
                    model.addAttribute("code", -100000);
                    return "common/fail";
                }
            case 8:
                if (DataUtils.isNullOrEmpty(id)) {
                    log.info("get id is null！");
                    model.addAttribute("code", -1000);
                    return "common/fail";
                }

                log.info("param scoreLogId is: " + id);

                log.info("get scoreType is: " + 8);


                try {


                    AttendanceLog attendanceLog = attendanceLogService.getObjectById(id);
                    if (attendanceLog == null) {

                        model.addAttribute("code", -9004);
                        return "common/fail";
                    }

                    Staff staff = staffService.getObjectById(attendanceLog.getStaffId());
                    log.info("get staffId is: " + staff.getId());


                    param = DynamicSQLUtil.getScoreList(id, 8);

                    List<Long> ids = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, param, 0, Integer.MAX_VALUE);
                    log.info("get ids is: " + ids.size());
                    ScoreLog scoreLog = scoreLogService.getObjectById(ids.get(0));
                    log.info("get scoreLog is: " + scoreLog);


                    model.addAttribute("staff", staff);
                    model.addAttribute("attendanceLog", attendanceLog);
                    model.addAttribute("scoreLog", scoreLog);
                    model.addAttribute("code", 0);

                    return "json/attendanceLog/json/attendanceLogDetailJson";


                } catch (Throwable t) {
                    log.error(t.getMessage());
                    log.error("get attendanceLog error,id is  " + id);
                    t.printStackTrace();
                    model.addAttribute("code", -100000);
                    return "common/fail";

                }
            default:
        }
        return result;
    }

    /**
     * @param request
     * @param response
     * @param model
     * @param
     * @Author hfismyangel@163.com
     * @Description:企业哲学详情特殊
     * @Date: 15:54 2017/9/27
     */
    @RequestMapping(value = "/a/u/philo/{id}/{adminId}", method = RequestMethod.GET)
    public String addPhilosophy(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Long adminId)
            throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get id is: " + id);
        if (DataUtils.isNullOrEmpty(adminId)) {
            log.info("get adminId is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get adminId is: " + id);
        try {
            Map<String, Object> map = DynamicSQLUtil.searelation(adminId, id);
            List<Long> count = staffPhilosophyRelationService.getIdsByDynamicCondition(StaffPhilosophyRelation.class, map, 0, Integer.MAX_VALUE);
            log.info("get count is: " + count);

            Philosophy philosophy = philosophyService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(philosophy)) {
                log.info("get philosophy is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get philosophy is: " + id);
            if (count == null || count.size() == ConstantItem.ZERO) {
                philosophy.setArticleStatus(ConstantItem.ZERO);
            } else {
                philosophy.setArticleStatus(ConstantItem.ONE);
            }
            model.addAttribute("code", 0);
            model.addAttribute("philosophy", philosophy);
            return "json/philosophy/json/philosophyDetailJson";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get philosophy error 9");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
    }

    @RequestMapping(value = "/a/u/dispatcherReward/{id}", method = RequestMethod.GET)
    public String disPtch(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        /**
         *@Author hfismyangel@163.com
         *@Description:领导表扬详情
         *@Date: 16:10 2017/10/3
         * @param request
         * @param response
         * @param model
         * @param id
         */
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get id is: " + id);
        try {
            RewardLog rewardLog = rewardLogService.getObjectById(id);
            log.info("get rewardLog is: " + rewardLog.getId());

            if (DataUtils.isNullOrEmpty(rewardLog.getStaffId())) {
                log.info("get staffId is null！");
                model.addAttribute("code", -1000);
                return "common/fail";
            }
            log.info("get staffId is: " + rewardLog.getStaffId());

            Long staffId = rewardLog.getStaffId();
            Staff staff = staffService.getObjectById(staffId);

            log.info("get staffId is: " + staff.getId());

            model.addAttribute("code", 0);
            model.addAttribute("staff", staff);
            model.addAttribute("rewardLog", rewardLog);
            return "json/rewardLog/json/rewardLogDetailJson";

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get ranking error ");
            model.addAttribute("code", -100000);
            return "common/fail";
        }
    }
}

