/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.home.model.Tenant;
import com.ptteng.score.home.service.TenantService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TenantServiceImpl
extends BaseDaoServiceImpl
implements TenantService {
    private static final Log log = LogFactory.getLog(TenantServiceImpl.class);

    public Long insert(Tenant tenant) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + tenant));
        if (tenant == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        tenant.setCreateAt(Long.valueOf(currentTimeMillis));
        tenant.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)tenant);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + tenant));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Tenant> insertList(List<Tenant> tenantList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (tenantList == null ? "null" : Integer.valueOf(tenantList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(tenantList)) {
            return new ArrayList<Tenant>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Tenant tenant : tenantList) {
            tenant.setCreateAt(Long.valueOf(currentTimeMillis));
            tenant.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(tenantList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + tenantList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Tenant.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Tenant tenant) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (tenant == null ? "null" : tenant.getId())));
        boolean result = false;
        if (tenant == null) {
            return true;
        }
        tenant.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)tenant);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + tenant));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + tenant));
        }
        return result;
    }

    public boolean updateList(List<Tenant> tenantList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (tenantList == null ? "null" : Integer.valueOf(tenantList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(tenantList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Tenant tenant : tenantList) {
            tenant.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(tenantList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + tenantList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + tenantList.size()));
        return result;
    }

    public Tenant getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Tenant tenant = null;
        if (id == null) {
            return tenant;
        }
        try {
            tenant = (Tenant)this.dao.get(Tenant.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return tenant;
    }

    public List<Tenant> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List tenant = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Tenant>();
        }
        try {
            tenant = this.dao.getList(Tenant.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (tenant == null ? "null" : Integer.valueOf(tenant.size()))));
        return tenant;
    }

    public List<Long> getTenantIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTenantIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTenantIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTenantIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTenantIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

