/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.home.model.Goods;
import com.ptteng.score.home.service.GoodsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoodsServiceImpl
extends BaseDaoServiceImpl
implements GoodsService {
    private static final Log log = LogFactory.getLog(GoodsServiceImpl.class);

    public Long insert(Goods goods) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + goods));
        if (goods == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        goods.setCreateAt(Long.valueOf(currentTimeMillis));
        goods.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)goods);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + goods));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Goods> insertList(List<Goods> goodsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (goodsList == null ? "null" : Integer.valueOf(goodsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(goodsList)) {
            return new ArrayList<Goods>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Goods goods : goodsList) {
            goods.setCreateAt(Long.valueOf(currentTimeMillis));
            goods.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(goodsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + goodsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Goods.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Goods goods) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (goods == null ? "null" : goods.getId())));
        boolean result = false;
        if (goods == null) {
            return true;
        }
        goods.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)goods);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + goods));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + goods));
        }
        return result;
    }

    public boolean updateList(List<Goods> goodsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (goodsList == null ? "null" : Integer.valueOf(goodsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(goodsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Goods goods : goodsList) {
            goods.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(goodsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + goodsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + goodsList.size()));
        return result;
    }

    public Goods getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Goods goods = null;
        if (id == null) {
            return goods;
        }
        try {
            goods = (Goods)this.dao.get(Goods.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return goods;
    }

    public List<Goods> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List goods = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Goods>();
        }
        try {
            goods = this.dao.getList(Goods.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (goods == null ? "null" : Integer.valueOf(goods.size()))));
        return goods;
    }

    public List<Long> getGoodsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGoodsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGoodsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGoodsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

