/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.home.model.Manager;
import com.ptteng.score.home.service.ManagerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagerServiceImpl
extends BaseDaoServiceImpl
implements ManagerService {
    private static final Log log = LogFactory.getLog(ManagerServiceImpl.class);

    public Long insert(Manager manager) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + manager));
        if (manager == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        manager.setCreateAt(Long.valueOf(currentTimeMillis));
        manager.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)manager);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + manager));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Manager> insertList(List<Manager> managerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (managerList == null ? "null" : Integer.valueOf(managerList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(managerList)) {
            return new ArrayList<Manager>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Manager manager : managerList) {
            manager.setCreateAt(Long.valueOf(currentTimeMillis));
            manager.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(managerList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + managerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Manager.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Manager manager) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (manager == null ? "null" : manager.getId())));
        boolean result = false;
        if (manager == null) {
            return true;
        }
        manager.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)manager);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + manager));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + manager));
        }
        return result;
    }

    public boolean updateList(List<Manager> managerList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (managerList == null ? "null" : Integer.valueOf(managerList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(managerList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Manager manager : managerList) {
            manager.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(managerList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + managerList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + managerList.size()));
        return result;
    }

    public Manager getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Manager manager = null;
        if (id == null) {
            return manager;
        }
        try {
            manager = (Manager)this.dao.get(Manager.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return manager;
    }

    public List<Manager> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List manager = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Manager>();
        }
        try {
            manager = this.dao.getList(Manager.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (manager == null ? "null" : Integer.valueOf(manager.size()))));
        return manager;
    }

    public List<Long> getManagerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countManagerIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getManagerIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getManagerIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getManagerIdsByRoleID(Long rid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by rid,start,limit  : " + rid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsByRoleID", new Object[]{rid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + rid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getManagerIdsByRoleIDAndStatus(Long rid, String status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by rid,status,start,limit  : " + rid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getManagerIdsByRoleIDAndStatus", new Object[]{rid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + rid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

