/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.home.model.Staff;
import com.ptteng.score.home.service.StaffService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaffServiceImpl
extends BaseDaoServiceImpl
implements StaffService {
    private static final Log log = LogFactory.getLog(StaffServiceImpl.class);

    public Long insert(Staff staff) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + staff));
        if (staff == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        staff.setCreateAt(Long.valueOf(currentTimeMillis));
        staff.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)staff);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + staff));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Staff> insertList(List<Staff> staffList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (staffList == null ? "null" : Integer.valueOf(staffList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(staffList)) {
            return new ArrayList<Staff>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Staff staff : staffList) {
            staff.setCreateAt(Long.valueOf(currentTimeMillis));
            staff.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(staffList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + staffList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Staff.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Staff staff) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (staff == null ? "null" : staff.getId())));
        boolean result = false;
        if (staff == null) {
            return true;
        }
        staff.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)staff);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + staff));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + staff));
        }
        return result;
    }

    public boolean updateList(List<Staff> staffList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (staffList == null ? "null" : Integer.valueOf(staffList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(staffList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Staff staff : staffList) {
            staff.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(staffList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + staffList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + staffList.size()));
        return result;
    }

    public Staff getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Staff staff = null;
        if (id == null) {
            return staff;
        }
        try {
            staff = (Staff)this.dao.get(Staff.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return staff;
    }

    public List<Staff> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List staff = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Staff>();
        }
        try {
            staff = this.dao.getList(Staff.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (staff == null ? "null" : Integer.valueOf(staff.size()))));
        return staff;
    }

    public List<Long> getStaffIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStaffIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStaffIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStaffIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStaffIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

