/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.admin.model.ScoreType;
import com.ptteng.score.admin.service.ScoreTypeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScoreTypeServiceImpl
extends BaseDaoServiceImpl
implements ScoreTypeService {
    private static final Log log = LogFactory.getLog(ScoreTypeServiceImpl.class);

    public Long insert(ScoreType scoreType) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + scoreType));
        if (scoreType == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        scoreType.setCreateAt(Long.valueOf(currentTimeMillis));
        scoreType.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)scoreType);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + scoreType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ScoreType> insertList(List<ScoreType> scoreTypeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (scoreTypeList == null ? "null" : Integer.valueOf(scoreTypeList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(scoreTypeList)) {
            return new ArrayList<ScoreType>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreType scoreType : scoreTypeList) {
            scoreType.setCreateAt(Long.valueOf(currentTimeMillis));
            scoreType.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(scoreTypeList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + scoreTypeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ScoreType.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ScoreType scoreType) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (scoreType == null ? "null" : scoreType.getId())));
        boolean result = false;
        if (scoreType == null) {
            return true;
        }
        scoreType.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)scoreType);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + scoreType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + scoreType));
        }
        return result;
    }

    public boolean updateList(List<ScoreType> scoreTypeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (scoreTypeList == null ? "null" : Integer.valueOf(scoreTypeList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(scoreTypeList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreType scoreType : scoreTypeList) {
            scoreType.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(scoreTypeList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + scoreTypeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + scoreTypeList.size()));
        return result;
    }

    public ScoreType getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ScoreType scoreType = null;
        if (id == null) {
            return scoreType;
        }
        try {
            scoreType = (ScoreType)this.dao.get(ScoreType.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return scoreType;
    }

    public List<ScoreType> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List scoreType = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ScoreType>();
        }
        try {
            scoreType = this.dao.getList(ScoreType.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (scoreType == null ? "null" : Integer.valueOf(scoreType.size()))));
        return scoreType;
    }

    public List<Long> getScoreTypeIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getScoreTypeIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countScoreTypeIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getScoreTypeIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getScoreTypeIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

