/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.admin.model.Philosophy;
import com.ptteng.score.admin.service.PhilosophyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhilosophyServiceImpl
extends BaseDaoServiceImpl
implements PhilosophyService {
    private static final Log log = LogFactory.getLog(PhilosophyServiceImpl.class);

    public Long insert(Philosophy philosophy) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + philosophy));
        if (philosophy == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        philosophy.setCreateAt(Long.valueOf(currentTimeMillis));
        philosophy.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)philosophy);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + philosophy));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Philosophy> insertList(List<Philosophy> philosophyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (philosophyList == null ? "null" : Integer.valueOf(philosophyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(philosophyList)) {
            return new ArrayList<Philosophy>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Philosophy philosophy : philosophyList) {
            philosophy.setCreateAt(Long.valueOf(currentTimeMillis));
            philosophy.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(philosophyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + philosophyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Philosophy.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Philosophy philosophy) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (philosophy == null ? "null" : philosophy.getId())));
        boolean result = false;
        if (philosophy == null) {
            return true;
        }
        philosophy.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)philosophy);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + philosophy));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + philosophy));
        }
        return result;
    }

    public boolean updateList(List<Philosophy> philosophyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (philosophyList == null ? "null" : Integer.valueOf(philosophyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(philosophyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Philosophy philosophy : philosophyList) {
            philosophy.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(philosophyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + philosophyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + philosophyList.size()));
        return result;
    }

    public Philosophy getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Philosophy philosophy = null;
        if (id == null) {
            return philosophy;
        }
        try {
            philosophy = (Philosophy)this.dao.get(Philosophy.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return philosophy;
    }

    public List<Philosophy> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List philosophy = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Philosophy>();
        }
        try {
            philosophy = this.dao.getList(Philosophy.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (philosophy == null ? "null" : Integer.valueOf(philosophy.size()))));
        return philosophy;
    }

    public List<Long> getPhilosophyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPhilosophyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPhilosophyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPhilosophyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPhilosophyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

