/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.admin.model.Notice;
import com.ptteng.score.admin.service.NoticeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoticeServiceImpl
extends BaseDaoServiceImpl
implements NoticeService {
    private static final Log log = LogFactory.getLog(NoticeServiceImpl.class);

    public Long insert(Notice notice) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + notice));
        if (notice == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        notice.setCreateAt(Long.valueOf(currentTimeMillis));
        notice.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)notice);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + notice));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Notice> insertList(List<Notice> noticeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (noticeList == null ? "null" : Integer.valueOf(noticeList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(noticeList)) {
            return new ArrayList<Notice>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Notice notice : noticeList) {
            notice.setCreateAt(Long.valueOf(currentTimeMillis));
            notice.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(noticeList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + noticeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Notice.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Notice notice) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (notice == null ? "null" : notice.getId())));
        boolean result = false;
        if (notice == null) {
            return true;
        }
        notice.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)notice);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + notice));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + notice));
        }
        return result;
    }

    public boolean updateList(List<Notice> noticeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (noticeList == null ? "null" : Integer.valueOf(noticeList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(noticeList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Notice notice : noticeList) {
            notice.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(noticeList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + noticeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + noticeList.size()));
        return result;
    }

    public Notice getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Notice notice = null;
        if (id == null) {
            return notice;
        }
        try {
            notice = (Notice)this.dao.get(Notice.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return notice;
    }

    public List<Notice> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List notice = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Notice>();
        }
        try {
            notice = this.dao.getList(Notice.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (notice == null ? "null" : Integer.valueOf(notice.size()))));
        return notice;
    }

    public List<Long> getNoticeIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getNoticeIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countNoticeIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getNoticeIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getNoticeIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

