/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.admin.model.Department;
import com.ptteng.score.admin.service.DepartmentService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DepartmentServiceImpl
extends BaseDaoServiceImpl
implements DepartmentService {
    private static final Log log = LogFactory.getLog(DepartmentServiceImpl.class);

    public Long insert(Department department) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + department));
        if (department == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        department.setCreateAt(Long.valueOf(currentTimeMillis));
        department.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)department);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + department));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Department> insertList(List<Department> departmentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (departmentList == null ? "null" : Integer.valueOf(departmentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(departmentList)) {
            return new ArrayList<Department>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Department department : departmentList) {
            department.setCreateAt(Long.valueOf(currentTimeMillis));
            department.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(departmentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + departmentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Department.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Department department) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (department == null ? "null" : department.getId())));
        boolean result = false;
        if (department == null) {
            return true;
        }
        department.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)department);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + department));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + department));
        }
        return result;
    }

    public boolean updateList(List<Department> departmentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (departmentList == null ? "null" : Integer.valueOf(departmentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(departmentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Department department : departmentList) {
            department.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(departmentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + departmentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + departmentList.size()));
        return result;
    }

    public Department getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Department department = null;
        if (id == null) {
            return department;
        }
        try {
            department = (Department)this.dao.get(Department.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return department;
    }

    public List<Department> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List department = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Department>();
        }
        try {
            department = this.dao.getList(Department.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (department == null ? "null" : Integer.valueOf(department.size()))));
        return department;
    }

    public List<Long> getDepartmentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDepartmentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDepartmentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDepartmentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDepartmentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

