/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.roster.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.roster.common.model.Roster;
import com.ptteng.roster.common.service.RosterService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RosterServiceImpl
extends BaseDaoServiceImpl
implements RosterService {
    private static final Log log = LogFactory.getLog(RosterServiceImpl.class);

    public Long insert(Roster roster) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + roster));
        if (roster == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        roster.setCreateAt(Long.valueOf(currentTimeMillis));
        roster.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)roster);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + roster));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Roster> insertList(List<Roster> rosterList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (rosterList == null ? "null" : Integer.valueOf(rosterList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(rosterList)) {
            return new ArrayList<Roster>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Roster roster : rosterList) {
            roster.setCreateAt(Long.valueOf(currentTimeMillis));
            roster.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(rosterList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + rosterList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Roster.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Roster roster) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (roster == null ? "null" : roster.getId())));
        boolean result = false;
        if (roster == null) {
            return true;
        }
        roster.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)roster);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + roster));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + roster));
        }
        return result;
    }

    public boolean updateList(List<Roster> rosterList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (rosterList == null ? "null" : Integer.valueOf(rosterList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(rosterList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Roster roster : rosterList) {
            roster.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(rosterList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + rosterList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + rosterList.size()));
        return result;
    }

    public Roster getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Roster roster = null;
        if (id == null) {
            return roster;
        }
        try {
            roster = (Roster)this.dao.get(Roster.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return roster;
    }

    public List<Roster> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List roster = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Roster>();
        }
        try {
            roster = this.dao.getList(Roster.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (roster == null ? "null" : Integer.valueOf(roster.size()))));
        return roster;
    }

    public List<Long> getRosterIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRosterIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRosterIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRosterIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRosterIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

