/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.roster.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.roster.common.model.Love;
import com.ptteng.roster.common.service.LoveService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoveServiceImpl
extends BaseDaoServiceImpl
implements LoveService {
    private static final Log log = LogFactory.getLog(LoveServiceImpl.class);

    public Long insert(Love love) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + love));
        if (love == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        love.setCreateAt(Long.valueOf(currentTimeMillis));
        love.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)love);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + love));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Love> insertList(List<Love> loveList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (loveList == null ? "null" : Integer.valueOf(loveList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(loveList)) {
            return new ArrayList<Love>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Love love : loveList) {
            love.setCreateAt(Long.valueOf(currentTimeMillis));
            love.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(loveList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + loveList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Love.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Love love) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (love == null ? "null" : love.getId())));
        boolean result = false;
        if (love == null) {
            return true;
        }
        love.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)love);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + love));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + love));
        }
        return result;
    }

    public boolean updateList(List<Love> loveList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (loveList == null ? "null" : Integer.valueOf(loveList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(loveList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Love love : loveList) {
            love.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(loveList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + loveList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + loveList.size()));
        return result;
    }

    public Love getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Love love = null;
        if (id == null) {
            return love;
        }
        try {
            love = (Love)this.dao.get(Love.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return love;
    }

    public List<Love> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List love = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Love>();
        }
        try {
            love = this.dao.getList(Love.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (love == null ? "null" : Integer.valueOf(love.size()))));
        return love;
    }

    public Long getLoveIdByUidAndRid(Long uid, Long rid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,name  : " + uid + " , " + rid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getLoveIdByUidAndRid", new Object[]{uid, rid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid, rid  : " + uid + " , " + rid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getLoveIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid: " + uid));
        }
        List idList = null;
        try {
            idList = this.dao.getIdList("getLoveIdsByUid", new Object[]{uid}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get Love ids  wrong by uid  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

