/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.roster.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.roster.common.model.Report;
import com.ptteng.roster.common.service.ReportService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportServiceImpl
extends BaseDaoServiceImpl
implements ReportService {
    private static final Log log = LogFactory.getLog(ReportServiceImpl.class);

    public Long insert(Report report) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + report));
        if (report == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        report.setCreateAt(Long.valueOf(currentTimeMillis));
        report.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)report);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + report));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Report> insertList(List<Report> reportList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (reportList == null ? "null" : Integer.valueOf(reportList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(reportList)) {
            return new ArrayList<Report>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Report report : reportList) {
            report.setCreateAt(Long.valueOf(currentTimeMillis));
            report.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(reportList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + reportList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Report.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Report report) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (report == null ? "null" : report.getId())));
        boolean result = false;
        if (report == null) {
            return true;
        }
        report.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)report);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + report));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + report));
        }
        return result;
    }

    public boolean updateList(List<Report> reportList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (reportList == null ? "null" : Integer.valueOf(reportList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(reportList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Report report : reportList) {
            report.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(reportList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + reportList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + reportList.size()));
        return result;
    }

    public Report getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Report report = null;
        if (id == null) {
            return report;
        }
        try {
            report = (Report)this.dao.get(Report.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return report;
    }

    public List<Report> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List report = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Report>();
        }
        try {
            report = this.dao.getList(Report.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (report == null ? "null" : Integer.valueOf(report.size()))));
        return report;
    }

    public List<Long> getReportIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getReportIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countReportIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getReportIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getReportIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

