/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.roster.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.roster.common.model.RosterReport;
import com.ptteng.roster.common.service.RosterReportService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RosterReportServiceImpl
extends BaseDaoServiceImpl
implements RosterReportService {
    private static final Log log = LogFactory.getLog(RosterReportServiceImpl.class);

    public Long insert(RosterReport rosterReport) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + rosterReport));
        if (rosterReport == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        rosterReport.setCreateAt(Long.valueOf(currentTimeMillis));
        rosterReport.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)rosterReport);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + rosterReport));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RosterReport> insertList(List<RosterReport> rosterReportList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (rosterReportList == null ? "null" : Integer.valueOf(rosterReportList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(rosterReportList)) {
            return new ArrayList<RosterReport>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RosterReport rosterReport : rosterReportList) {
            rosterReport.setCreateAt(Long.valueOf(currentTimeMillis));
            rosterReport.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(rosterReportList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + rosterReportList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RosterReport.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RosterReport rosterReport) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (rosterReport == null ? "null" : rosterReport.getId())));
        boolean result = false;
        if (rosterReport == null) {
            return true;
        }
        rosterReport.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)rosterReport);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + rosterReport));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + rosterReport));
        }
        return result;
    }

    public boolean updateList(List<RosterReport> rosterReportList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (rosterReportList == null ? "null" : Integer.valueOf(rosterReportList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(rosterReportList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RosterReport rosterReport : rosterReportList) {
            rosterReport.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(rosterReportList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + rosterReportList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + rosterReportList.size()));
        return result;
    }

    public RosterReport getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RosterReport rosterReport = null;
        if (id == null) {
            return rosterReport;
        }
        try {
            rosterReport = (RosterReport)this.dao.get(RosterReport.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return rosterReport;
    }

    public List<RosterReport> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List rosterReport = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RosterReport>();
        }
        try {
            rosterReport = this.dao.getList(RosterReport.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (rosterReport == null ? "null" : Integer.valueOf(rosterReport.size()))));
        return rosterReport;
    }

    public List<Long> getRosterReportIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRosterReportIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRosterReportIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRosterReportIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRosterReportIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

