package com.ptteng.rent.user.utils.wx;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import com.qding.common.util.http.cookie.IdentityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

import java.io.IOException;

public class ImgStorageTencentV4 {

    private static final Log log = LogFactory.getLog(ImgStorageTencentV4.class);

    private String APP_ID;
    private String SECRET_ID;
    private String SECRET_KEY;
    private COSClient cosClient;

    public void initClient() {
        log.info(" init start ");
        if (null != APP_ID) {
            // 初始化客户端配置
            ClientConfig clientConfig = new ClientConfig();
            // 设置bucket所在的区域，比如广州(gz), 天津(tj)
            clientConfig.setRegion("bj");
            // 初始化秘钥信息
            Credentials cred = new Credentials(Long.valueOf(APP_ID), SECRET_ID, SECRET_KEY);
            // 初始化cosClient
            cosClient = new COSClient(clientConfig, cred);
        }
        log.info(" init cos success ");
    }

    /**
     * 上传文件
     *
     * @param bucketName    桶名称
     * @param cosFilePath   上传COS资源名称
     * @param localFilePath 资源本地路径
     * @return
     * @throws IOException
     */
    public String imgStorage(String bucketName, String cosFilePath, String localFilePath) throws IOException {

        log.info(" storage start  bucketName=" + bucketName + "，cosFilePath=" + cosFilePath + ",localFilePath=" + localFilePath);
        try {

            initClient();
            // 默认不覆盖, 如果cos上已有文件, 则返回错误
            UploadFileRequest uploadFileRequest =
                    new UploadFileRequest(bucketName, "/" + cosFilePath, localFilePath);
            uploadFileRequest.setEnableShaDigest(false);
            String uploadFileRet = this.cosClient.uploadFile(uploadFileRequest);
            log.info("upload file ret:" + uploadFileRet);

            JSONObject jsonObject = new JSONObject(uploadFileRet);
            Integer code = (Integer) jsonObject.get("code");
            Integer success = 0;
            if (success.equals(code)) {
                log.info(" upload file success ");
                JSONObject data = new JSONObject(jsonObject.get("data").toString());
                String url = data.get("source_url").toString();
                System.out.println(" url = " + url);
                return url;
            } else {
                log.info(" upload file failure ");

            }
            log.info("uploadFile result:" + uploadFileRet);

            cosClient.shutdown();
            log.info("shutdown!");

            return null;
        } catch (Exception e) {
            log.info(" upload file failure ");
            e.printStackTrace();
            return null;
        }

    }

    public String getAPP_ID() {
        return APP_ID;
    }

    public String getSECRET_ID() {
        return SECRET_ID;
    }

    public String getSECRET_KEY() {
        return SECRET_KEY;
    }

    public void setAPP_ID(String APP_ID) {
        this.APP_ID = APP_ID;
    }

    public void setSECRET_ID(String SECRET_ID) {
        this.SECRET_ID = SECRET_ID;
    }

    public void setSECRET_KEY(String SECRET_KEY) {
        this.SECRET_KEY = SECRET_KEY;
    }

    public static void main(String[] args) throws IOException {

//        ImgStorageTencentV4 imgStorageTencentV4 = new ImgStorageTencentV4();
//
//        imgStorageTencentV4.imgStorage("lessee", "8769240c-d6ba-4f35-b313-1d2ecb06f2c0.jpg", "D:\\VMware\\test.jpg");

        String token = IdentityUtil.encodeCookie("phone", 524L);

        log.info(token);

        String fuck = "<groupId>org.jdom</groupId><groupId>org.jd<groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId>om</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jd<groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId>om</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jd<groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>org.jdom</groupId><groupId>or";

        System.out.println(fuck.length());

    }


}


