package com.ptteng.rent.user.utils;

import com.google.gson.Gson;
import com.ptteng.rent.user.constant.UserConstant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowApiResultUtils {

    private static final Log log = LogFactory.getLog(ShowApiResultUtils.class);

    public static UserVerifiedModel getShowApiResultCode(String name, String IDNumber) {

        // 调用易源实名认证
        String res = new ShowApiRequest(UserConstant.ID_SHOW_API_URL, UserConstant.APP_ID,
                UserConstant.SECRET)
                .addTextPara("idcard", IDNumber)
                .addTextPara("name", name)
                .post();

        log.info("verified res is :" + res);

        Gson gson = new Gson();

        UserVerifiedModel userVerifiedModel = gson.fromJson(res, UserVerifiedModel.class);

        log.info("result code is :" + userVerifiedModel.getShowapi_res_body().getCode());

        return userVerifiedModel;

    }

    public static int getAnthorCode(String name, String IDNumber) {

        // 调用易源实名认证
        String res = new ShowApiRequest(UserConstant.ID_SHOW_API_URL, UserConstant.APP_ID,
                UserConstant.SECRET)
                .addTextPara("idcard", IDNumber)
                .addTextPara("name", name)
                .post();

        log.info("verified res is :" + res);

        Gson gson = new Gson();

        UserVerifiedModel userVerifiedModel = gson.fromJson(res, UserVerifiedModel.class);

        log.info("result code is :" + userVerifiedModel.getShowapi_res_code());

        return userVerifiedModel.getShowapi_res_code();

    }

    public static String getShowApiResultMsg(String name, String IDNumber) {

        // 调用易源实名认证 {"showapi_res_error":"未找到可用资源包，请检查是否未订购套餐，或者当前调用量已为0。","showapi_res_code":-2,"showapi_res_body":{}}
//        {"showapi_res_error":"","showapi_res_code":0,"showapi_res_body":{"msg":"身份证与姓名不匹配","ret_code":0,"code":1}}
        String res = new ShowApiRequest(UserConstant.ID_SHOW_API_URL, UserConstant.APP_ID,
                UserConstant.SECRET)
                .addTextPara("idcard", IDNumber)
                .addTextPara("name", name)
                .post();

        log.info("verified res is :" + res);

        Gson gson = new Gson();

        UserVerifiedModel userVerifiedModel = gson.fromJson(res, UserVerifiedModel.class);

        log.info("result code is :" + userVerifiedModel.getShowapi_res_body().getCode());

        return userVerifiedModel.getShowapi_res_body().getMsg();

    }

    public static int getShowApiSystemResultCode(String name, String IDNumber) {

        // 调用易源实名认证
        String res = new ShowApiRequest(UserConstant.ID_SHOW_API_URL, UserConstant.APP_ID,
                UserConstant.SECRET)
                .addTextPara("idcard", IDNumber)
                .addTextPara("name", name)
                .post();

        log.info("verified res is :" + res);

        Gson gson = new Gson();

        UserVerifiedModel userVerifiedModel = gson.fromJson(res, UserVerifiedModel.class);

        log.info("result code is :" + userVerifiedModel.getShowapi_res_body().getCode());

        return userVerifiedModel.getShowapi_res_code();

    }

}
