package com.ptteng.rent.user.utils;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.model.UserCommentRelation;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author ss127
 * @date 2018/6/7
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /**
     * 首页用户列表
     *
     * @param sex         性别
     * @param tag         标签
     * @param positioning 当前定位
     * @param count
     * @return
     */
    public static Map<String, Object> getUserListBySexAndTagAndPosing(Integer sex, String tag, String positioning, Integer sort, boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(sex)) {

            params.put("sex", sex);

        }

        if (DataUtils.isNotNullOrEmpty(tag)) {

            params.put("tag", "'" + tag + "'");

        }

        if (DataUtils.isNotNullOrEmpty(positioning)) {

            params.put("positioning", "'" + positioning + "'");

        }

        // 出租人退出账号后不会出现在出租列表中
        params.put("login_status", User.LOGIN);
        // 冻结用户不出现
        params.put("status", User.STATUS_OFF);

        // 用户类型出租人
        params.put("user_type", User.LESSOR);

        // 出租人完成价格设置
        params.put("toll & <>", "'" + "'");

        // 出租人完成技能设置
        params.put("skill & <>", "'" + "'");

        params.put("we_chat & <>", "'" + "'");

        if (count) {

            params.put("@query", "count(id)");

        } else {

            params.put("@order", "create_at desc");

            params.put("@query", "id");

        }

        params.put("@table", "user");

        return params;

    }

    /**
     * 出租人评价列表
     *
     * @param lessorId 出租人ID
     * @param count
     * @return
     */
    public static Map<String, Object> getLessorCommentList(Long lessorId, Long lesseeId,boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(lessorId)) {

            params.put("lessor_id", lessorId);

        }

        if (DataUtils.isNotNullOrEmpty(lesseeId)) {

            params.put("lessee_id", lesseeId);

        }

        params.put("type", UserCommentRelation.LESSEE_TO_LESSOR);

        if (count) {

            params.put("@query", "count(id)");

        } else {

            params.put("@order", "create_at desc");

            params.put("@query", "id");

        }

        params.put("@table", "user_comment_relation");

        return params;

    }

    /**
     * 查看订单号是否唯一
     *
     * @param orderNumber 生成订单号
     * @return
     */
    public static Map<String, Object> getOidByOrderNumber(String orderNumber) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(orderNumber)) {

            params.put("order_no", orderNumber);

        }

        params.put("@query", "id");

        params.put("@table", "orders");


        return params;

    }

    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type, String name, String value,
                                                           String comments, Long startAt, Long endAt,
                                                           Long id, Long updateStartAt, Long updateEndAt,
                                                           boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("create_at &  <= ", endAt);
        }

        if (DataUtils.isNotNullOrEmpty(updateStartAt)) {
            params.put("update_at & >= ", updateStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(updateEndAt)) {
            params.put("update_at &  <= ", updateEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(id)) {

            params.put("id", id);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getLesseeProcessingOrders(Long lesseeId) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(lesseeId)) {

            params.put("lessee_id", lesseeId);

        }

        params.put("status & in ", "(" + "1,2,3,4,5,6,7,8,10,13" + ")");

        params.put("@query", "count(id)");


        params.put("@table", "orders");

        return params;

    }

    public static Map<String, Object> getLessorOrderList(Long uid) {

        Map<String, Object> params = new HashMap<>();


        if (DataUtils.isNotNullOrEmpty(uid)) {

            params.put("lessor_id  ", uid + " or lessee_id  = " + uid);

        }

        params.put("status & in ", "(" + "1,2,3,5,6,7,8" + ")");

        params.put("@query", "id");


        params.put("@table", "orders");

        return params;

    }



    public static Map<String, Object> getUserByLessorIdAndLesseeId(String allUid) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(allUid)) {

            params.put("id & in ","(" +  allUid + ")");

        }

        params.put("@query", "id");


        params.put("@table", "user");

        return params;

    }


    public static Map<String, Object> getLesseeOrdersListByUidAndStatus(Long lesseeId) {

        Map<String, Object> params = new HashMap<>();

//        if (DataUtils.isNotNullOrEmpty(lesseeId)) {
//
//            params.put("lessee_id", lesseeId);
//
//        }

        params.put("(status in (1,2,3,5,6,7,8) or lessee_evaluation_status=1) and lesseeId",lesseeId);

        params.put("@query", "id");

        params.put("@order", " create_at desc  ");

        params.put("@table", "orders");

        return params;

    }

    public static Map<String, Object> getLessorOrdersListByUidAndStatus(Long lessorId) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(lessorId)) {

            params.put("lessee_id", lessorId);

        }

        params.put("status & in ", "(" + "1,2,3,5,6,7,8" + ") or lessor_evaluation_status=1");

        params.put("@query", "id");

        params.put("@order", " update_at desc  ");

        params.put("@table", "orders");

        return params;

    }


    public static Map<String, Object> getFormIdByOid(Long  uid) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(uid)) {

            params.put("uid", uid);

        }

        params.put("@query", "id");

        params.put("@table", "wx_form_id_warehouse");


        return params;

    }
}
