package com.ptteng.rent.user.utils;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.user.constant.WxConfig;
import com.ptteng.rent.user.model.WxFormIdWarehouse;
import com.ptteng.rent.user.service.WxFormIdWarehouseService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;

/**
 * @author cjsff
 * 2018/6/21
 */
@Component
public class AppletSendMessage {

    private static final Log log = LogFactory.getLog(AppletSendMessage.class);

    public static AppletSendMessage appletSendMessage;

    @Autowired
    private WxFormIdWarehouseService wxFormIdWarehouseService;

    @PostConstruct
    public void init() {
        appletSendMessage = this;
    }

    private static String getFormId(Long uid) throws ServiceException, ServiceDaoException {

        Map<String, Object> getFormIdByOidParam = DynamicUtil.getFormIdByOid(uid);

        log.info("get form id by oid param is :" + getFormIdByOidParam);

        List<Long> formIds = appletSendMessage.wxFormIdWarehouseService.getIdsByDynamicCondition(WxFormIdWarehouse
                .class, getFormIdByOidParam, 0, 10);

        log.info("form id is :" + formIds);


        log.info("----------------------------------");

        WxFormIdWarehouse wxFormIdWarehouse = new WxFormIdWarehouse();

        String formId = "";

        log.info("----------------------------------");

        if (CollectionUtils.isNotEmpty(formIds)) {


            log.info("----------------------------------");

            wxFormIdWarehouse = appletSendMessage.wxFormIdWarehouseService.getObjectById(formIds.get(0));

            Long interval = System.currentTimeMillis() - wxFormIdWarehouse.getCreateAt();

            log.info("interval is :" + interval);

            // form_id有效期7天
            if (WxFormIdWarehouse.EXPIRED < interval) {

                appletSendMessage.wxFormIdWarehouseService.delete(wxFormIdWarehouse.getId());

                return getFormId(uid);

            }

            Integer type = wxFormIdWarehouse.getType();

            log.info("form_id type is :" + type);

            formId = wxFormIdWarehouse.getFormId();

            log.info("form_id is :" + formId);

            if (WxFormIdWarehouse.FROM.equals(type)) {

                appletSendMessage.wxFormIdWarehouseService.delete(wxFormIdWarehouse.getId());

            } else if (WxFormIdWarehouse.ORDER.equals(type)) {

                if (WxFormIdWarehouse.COUNT.equals(wxFormIdWarehouse.getCount())) {

                    appletSendMessage.wxFormIdWarehouseService.delete(wxFormIdWarehouse.getId());

                } else {

                    // 增加1次使用次数
                    wxFormIdWarehouse.setCount(wxFormIdWarehouse.getCount() + 1);

                    appletSendMessage.wxFormIdWarehouseService.update(wxFormIdWarehouse);

                }

            } else {

                return getFormId(uid);

            }

        }

        return formId;

    }


    /**
     * 出租人订单结束通知
     *
     * @param openid
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String orderEndMessage(String openid, String price,Long uid,Long oid) throws ServiceException,
            ServiceDaoException {

        String formId = getFormId(uid);

        log.info("===================================================");

        log.info("form id is ；" + formId);

        String sendWxMessage = "{  \n" +
                "     \"touser\":\"" + openid + "\",\n" +
                "     \"template_id\":\"" + WxConfig.ORDER_END + "\",  \n" +
                "     \"form_id\":\"" + formId + "\",  \n" +
                "     \"page\":\"" + "pages/index/index?oid=" + oid +     "\",  \n" +
                "     \"data\":{  \n" +
                "             \"keyword1\":{  \n" +
                "                 \"value\":\"" + price + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword2\": {  \n" +
                "                 \"value\":\"" + "已结束" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword3\": {  \n" +
                "                 \"value\":\"" + "订单已结束，感谢您的服务。" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             }  \n" +
                "     }  \n" +
                " }  ";


        return sendWxMessage;

    }


    /**
     * 退款申请通知
     *
     * @param openid     用户openID
     * @param lesseeNick 承租人昵称
     * @param price      订单价格
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String refundRequestNotificationMessage(String openid, String lesseeNick, String price,Long uid,Long oid)
            throws
            ServiceException,
            ServiceDaoException {

        String formId = getFormId(uid);

        log.info("===================================================");

        log.info("form id is ；" + formId);

        String sendWxMessage = "{  \n" +
                "     \"touser\":\"" + openid + "\",\n" +
                "     \"template_id\":\"" + WxConfig.REFUND_REQUEST_NOTIFICATION + "\",  \n" +
                "     \"form_id\":\"" + formId + "\",  \n" +
                "     \"page\":\"" + "pages/index/index?oid=" + oid +     "\",  \n" +
                "     \"data\":{  \n" +
                "             \"keyword1\":{  \n" +
                "                 \"value\":\"" + lesseeNick + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword2\": {  \n" +
                "                 \"value\":\"" + price + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword3\": {  \n" +
                "                 \"value\":\"" + "用户发起了申请退款，快去确认一下吧。" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             } \n" +
                "     }  \n" +
                " }  ";

        return sendWxMessage;

    }

    /**
     * 新订单通知
     *
     * @param openid
     * @param lesseeNick      承租人昵称
     * @param appointmentTime 租赁时间段（拼接）
     * @param price           订单金额
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String newOrderMessage(String openid, String lesseeNick, String appointmentTime, String price,Long
            uid,Long oid) throws
            ServiceException,
            ServiceDaoException {

        String formId = getFormId(uid);

        log.info("===================================================");

        log.info("form id is ；" + formId);

        String sendWxMessage = "{  \n" +
                "     \"touser\":\"" + openid + "\",\n" +
                "     \"template_id\":\"" + WxConfig.NEW_ORDER + "\",  \n" +
                "     \"form_id\":\"" + formId + "\",  \n" +
                "     \"page\":\"" + "pages/index/index?oid=" + oid +     "\",  \n" +
                "     \"data\":{  \n" +
                "             \"keyword1\":{  \n" +
                "                 \"value\":\"" + lesseeNick + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword2\": {  \n" +
                "                 \"value\":\"" + appointmentTime + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword3\": {  \n" +
                "                 \"value\":\"" + "待确认" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword4\": {  \n" +
                "                 \"value\":\"" + price + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword5\": {  \n" +
                "                 \"value\":\"" + "您有新的订单待确认，快去接单吧。" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             }  \n" +
                "     }  \n" +
                " }  ";

        return sendWxMessage;

    }

    /**
     * 承租人订单结束通知
     *
     * @param openid
     * @param duration   租赁时长
     * @param totalPrice 订单金额+服务费总和
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String lesseeOrderEndMessage(String openid, String duration, String totalPrice,Long uid,Long oid) throws
            ServiceException,
            ServiceDaoException {

        String formId = getFormId(uid);

        log.info("===================================================");

        log.info("form id is ；" + formId);

        String sendWxMessage = "{  \n" +
                "     \"touser\":\"" + openid + "\",\n" +
                "     \"template_id\":\"" + WxConfig.LESSEE_ORDER_END + "\",  \n" +
                "     \"form_id\":\"" + formId + "\",  \n" +
                "     \"page\":\"" + "pages/index/index?oid=" + oid +     "\",  \n" +
                "     \"data\":{  \n" +
                "             \"keyword1\":{  \n" +
                "                 \"value\":\"" + duration + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword2\": {  \n" +
                "                 \"value\":\"" + totalPrice + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword3\": {  \n" +
                "                 \"value\":\"" + "已结束" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword4\": {  \n" +
                "                 \"value\":\"" + "订单已结束，感谢您的使用。" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             }  \n" +
                "     }  \n" +
                " }  ";

        return sendWxMessage;

    }

    /**
     * 承租人订单确认通知
     *
     * @param openid
     * @param skill      当前出租用户所有技能标签
     * @param totalPrice 订单金额+服务费 总和
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String orderConfirmMessage(String openid, String skill, String totalPrice,Long uid,Long oid) throws
            ServiceException,
            ServiceDaoException {

        String formId = getFormId(uid);

        log.info("===================================================");

        log.info("form id is ；" + formId);

        String sendWxMessage = "{  \n" +
                "     \"touser\":\"" + openid + "\",\n" +
                "     \"template_id\":\"" + WxConfig.ORDER_CONFIRM + "\",  \n" +
                "     \"form_id\":\"" + formId + "\",  \n" +
                "     \"page\":\"" + "pages/index/index?oid=" + oid +     "\",  \n" +
                "     \"data\":{  \n" +
                "             \"keyword1\":{  \n" +
                "                 \"value\":\"" + skill + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword2\": {  \n" +
                "                 \"value\":\"" + totalPrice + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword3\": {  \n" +
                "                 \"value\":\"" + "进行中" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword4\": {  \n" +
                "                 \"value\":\"" + "订单已确认，快去联系TA吧。" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             }  \n" +
                "     }  \n" +
                " }  ";

        return sendWxMessage;

    }

    /**
     * 承租人下单成功通知
     *
     * @param openid
     * @param skill      当前出租用户所有技能标签
     * @param duration   租赁时长
     * @param totalPrice 订单金额+服务费 总和
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public static String payOrderSuccessMessage(String openid, String skill, String duration, String totalPrice,Long
            uid,Long oid) throws
            ServiceException,
            ServiceDaoException {

        String formId = getFormId(uid);

        log.info("===================================================");

        log.info("form id is ；" + formId);

        String sendWxMessage = "{  \n" +
                "     \"touser\":\"" + openid + "\",\n" +
                "     \"template_id\":\"" + WxConfig.PAY_ORDER_SUCCESS + "\",  \n" +
                "     \"form_id\":\"" + formId + "\",  \n" +
                "     \"page\":\"" + "pages/index/index?oid=" + oid +     "\",  \n" +
                "     \"data\":{  \n" +
                "             \"keyword1\":{  \n" +
                "                 \"value\":\"" + skill + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword2\": {  \n" +
                "                 \"value\":\"" + totalPrice + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword3\": {  \n" +
                "                 \"value\":\"" + "待确认" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword4\": {  \n" +
                "                 \"value\":\"" + duration + "小时\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             },  \n" +
                "             \"keyword5\": {  \n" +
                "                 \"value\":\"" + "您已下单成功，请等待对方确认。" + "\",  \n" +
                "                 \"color\":\"#173177\"  \n" +
                "             }  \n" +
                "     }  \n" +
                " }  ";

        return sendWxMessage;

    }

}
