package com.ptteng.rent.user.controller;

import com.ptteng.rent.user.model.WxFormIdWarehouse;
import com.ptteng.rent.user.service.WxFormIdWarehouseService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * WxFormIdWarehouse  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class WxFormIdWarehouseController {
	private static final Log log = LogFactory.getLog(WxFormIdWarehouseController.class);

	@Autowired
	private WxFormIdWarehouseService wxFormIdWarehouseService;


	/**
	 * 新增form_id
	 * @param request
	 * @param response
	 * @param model
	 * @param formId  用户触发表单提交或者支付产生的，用于在适当的时候发模板推送使用。
	 * @param type     formId来源   备注：1=表单，2=支付
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/formid", method = RequestMethod.POST)
	public String addWxFormIdWarehouseJson(HttpServletRequest request,
										   HttpServletResponse response, ModelMap model, String formId,Integer type,Long uid,Long oid)
			throws
			Exception {

		log.info("url is : /a/formid?formId=" + formId + "&type=" + type + "&uid=" +uid);

		if (DataUtils.isNullOrEmpty(formId)) {

			log.info("form_id is null");

			model.addAttribute("code", -6000);

			return "/common/success";

		}

		if (DataUtils.isNullOrEmpty(type)) {

			log.info("type is null");

			model.addAttribute("code", -6001);

			return "/common/success";

		}

		if (DataUtils.isNullOrEmpty(uid)) {

			log.info("uid is null");

			model.addAttribute("code", -2033);

			return "/common/success";

		}

		if (!WxFormIdWarehouse.FROM.equals(type) && !WxFormIdWarehouse.ORDER.equals(type)) {

			log.info("Illegal parameters");

			model.addAttribute("code", -996);

			return "/common/success";

		}

		if ("the formId is a mock one".equals(formId)) {

			log.info("I hope you play real");

			model.addAttribute("code", -6010);

			return "/common/success";

		}

		try {

			WxFormIdWarehouse wxFormIdWarehouse = new WxFormIdWarehouse();

			wxFormIdWarehouse.setFormId(formId);

			wxFormIdWarehouse.setType(type);

			wxFormIdWarehouse.setUid(uid);

			Long wid = wxFormIdWarehouseService.insert(wxFormIdWarehouse);

			log.info("wid is :" + wid);

			if (DataUtils.isNullOrEmpty(wid)) {

				log.info("insert error");

				model.addAttribute("code", -6002);

				return "/common/success";

			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add wxFormIdWarehouse error ");
			model.addAttribute("code", -6002);
		}

		return "/common/success";
	}


}

