/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.rent.admin.model.Constant;
import com.ptteng.rent.admin.model.Manager;
import com.ptteng.rent.admin.service.ConstantService;
import com.ptteng.rent.admin.service.ManagerService;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.etl.util.TransferUtils;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.community.common.weixin.service.WeiXinService;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class OrdersFindNormalEndEtl {
    private static final Log log = LogFactory.getLog(OrdersFindNormalEndEtl.class);
    private OrdersService ordersService;
    private ConstantService constantService;
    private ManagerService managerService;
    private UserService userService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private WeiXinService weixinService;
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 15000L;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"--------------ETL 2-----------------");
                    log.info((Object)"find normal orders etl is start!");
                    List<Orders> normalEndOrderList = this.findNormalEndOrders();
                    log.info((Object)("normal end order list size :" + normalEndOrderList.size()));
                    if (CollectionUtils.isEmpty(normalEndOrderList)) {
                        log.info((Object)"orders push etl not get any id ,sleep 15000 ms ");
                    } else {
                        this.processOrder(normalEndOrderList);
                    }
                    Thread.sleep(15000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(15000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Orders> findNormalEndOrders() {
        log.info((Object)"============------------===============");
        log.info((Object)"find normal end order method start!!!");
        List<Object> normalEndOrderList = new ArrayList<Orders>();
        Map<String, Object> conditions = DynamicUtil.getNormalEndOrderList();
        log.info((Object)("get normal end order params \uff1b" + conditions));
        try {
            List normalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isNotEmpty((Collection)normalEndOrderIds)) {
                normalEndOrderList = this.ordersService.getObjectsByIds(normalEndOrderIds);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return normalEndOrderList;
    }

    private void processOrder(List<Orders> normaoEndOrderList) throws ServiceException, ServiceDaoException, InterruptedException, IOException {
        log.info((Object)"***********************************");
        log.info((Object)"Transfer to lessor");
        ArrayList<Manager> managerUpdateList = new ArrayList<Manager>();
        Map managerMap = new HashMap();
        Map constantMap = new HashMap();
        try {
            ArrayList mids = MyListUtil.getList((Field)Orders.class.getDeclaredField("mid"), normaoEndOrderList);
            mids = new ArrayList(new HashSet(mids));
            List managerList = this.managerService.getObjectsByIds(mids);
            managerMap = MyListUtil.convert2Map((Field)Manager.class.getDeclaredField("id"), (List)managerList);
            List cids = this.constantService.getConstantIdsByType("broker", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List constantList = this.constantService.getObjectsByIds(cids);
            constantMap = MyListUtil.convert2Map((Field)Constant.class.getDeclaredField("name"), (List)constantList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty(normaoEndOrderList)) {
            for (Orders orders : normaoEndOrderList) {
                Long lessorId = orders.getLessorId();
                log.info((Object)("lessorId is :" + lessorId));
                log.info((Object)"\u7ed9\u51fa\u79df\u4eba\u8f6c\u8d26\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                String sql = "select open_id from user where id = " + lessorId;
                String lessorOpenid = (String)this.jdbcTemplate.queryForObject(sql, String.class);
                log.info((Object)("lessor openid is :" + lessorOpenid));
                BigDecimal ordersPrice = orders.getPrice().subtract(orders.getLessorServiceFee());
                log.info((Object)("orders lessor get money is :" + ordersPrice));
                String userStatusSQL = "select user_status from user where id = " + lessorId;
                Integer userStatus = this.jdbcTemplate.queryForInt(userStatusSQL);
                log.info((Object)("user status is :" + userStatus));
                try {
                    if (orders.getIsWithdraw().equals(Orders.IS_NOT_WITHDRAW)) {
                        Manager manager = (Manager)managerMap.get(orders.getMid());
                        if (DataUtils.isNotNullOrEmpty((Object)manager)) {
                            log.info((Object)("manager id is " + manager.getId()));
                            Constant constant = (Constant)constantMap.get(orders.getMid().toString());
                            if (DataUtils.isNotNullOrEmpty((Object)constant)) {
                                BigDecimal proportion = new BigDecimal(constant.getValue());
                                log.info((Object)("proportion is " + proportion));
                                if (proportion.compareTo(BigDecimal.ZERO) > 0 && proportion.compareTo(new BigDecimal(100)) < 1) {
                                    proportion = proportion.divide(new BigDecimal(100), 2, 5);
                                    manager.setIncome(manager.getIncome().add(proportion.multiply(orders.getLesseeServiceFee().add(orders.getLessorServiceFee()))));
                                    managerUpdateList.add(manager);
                                    orders.setIsWithdraw(Orders.IS_WITHORAW);
                                } else {
                                    log.warn((Object)("proportion error proportion=" + proportion));
                                }
                            } else {
                                log.info((Object)"proportion is not found");
                            }
                        } else {
                            log.warn((Object)("manager is not found,id is " + orders.getMid()));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                int code = TransferUtils.transferPay(lessorOpenid, ordersPrice.multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString(), orders.getOrderNo());
                log.info((Object)("code is :" + code));
                if (code != 0) continue;
                orders.setStatus(Orders.TRANSFERRED);
            }
            boolean boo = this.ordersService.updateList(normaoEndOrderList);
            if (boo) {
                log.info((Object)"order update status success");
                log.info((Object)("update manager size is " + managerUpdateList.size()));
                this.managerService.updateList(managerUpdateList);
            } else {
                log.info((Object)"order update status fail");
                log.info((Object)"-------------------------");
            }
        }
    }

    public OrdersService getOrdersService() {
        return this.ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public ConstantService getConstantService() {
        return this.constantService;
    }

    public void setConstantService(ConstantService constantService) {
        this.constantService = constantService;
    }

    public ManagerService getManagerService() {
        return this.managerService;
    }

    public void setManagerService(ManagerService managerService) {
        this.managerService = managerService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

