package com.ptteng.rent.etl.util;

import com.ptteng.rent.user.model.Orders;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by cjsff 2018年1月17日13:03:05
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /**
     * @param
     * @param
     * @return
     * @Description :查询待确认状态下承租人未接收超时订单
     */
    public static Map<String, Object> getAbnormalOrders() {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("status", Orders.LESSOR_IS_NOT_CONFIRMED);

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;
    }


    /**
     * 查询正常完成订单列表
     *
     * @return
     */
    public static Map<String, Object> getNormalEndOrderList() {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("status", Orders.COMPLETE_THE_ORDER_NORMALLY);

        //双发已评
//        params.put("lessor_evaluation_status", Orders.IS_EVALUATION);
//
//        params.put("lessee_evaluation_status", Orders.IS_EVALUATION);

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;
    }

    public static Map<String, Object> getRunOutOfTimeOrders() {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("status = 2 & ", " or status = 4  or status = 13");

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;
    }

    public static Map<String, Object> getNotEvaluationNormalEntOrders() {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("status", Orders.COMPLETE_THE_ORDER_NORMALLY);

        params.put("lessee_evaluation_status = 1 & ", "or lessor_evaluation_status=1");

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;
    }

    public static Map<String, Object> getOrdersTerminationUnconfirmedList() {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("status", Orders.PROCESSING_LESSEE_REFUND_LESSOR_IS_NOT_CONFIRMED);

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;
    }

    public static Map<String, Object> getLesseeRefundOrderList() {

        Map<String, Object> params = new HashMap<String, Object>();

        params.put("status & in ", "(" + "3,5,6,7,8,10,14" + ")");

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;
    }

}


