package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.base.Splitter;
import com.ptteng.rent.etl.util.CommentCountUtils;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.etl.util.RandomCommentUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.model.UserCommentRelation;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserCommentCountService;
import com.ptteng.rent.user.service.UserCommentRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author cjsff
 * 2018/7/1
 * 已结束订单（正常结束的订单）24小时未评论，系统自动评论
 */
public class OrdersTestEvaluationEtl {


    private static final Log log = LogFactory.getLog(OrdersTestEvaluationEtl.class);

    private OrdersService ordersService;

    private UserCommentRelationService userCommentRelationService;

    private UserCommentCountService userCommentCountService;

    /**
     * 一次任务检测多少条数据
     */
    private static final int TASK_LEN = 100;

    /**
     * 空转任务间隔休息毫秒数
     */
    private static final long SLEEP_MILLISECOND = 15000;

    private Long interval = 2000L;

    public OrdersTestEvaluationEtl() {
        super();
    }

    public void process() throws InterruptedException {

        while (true) {

            try {

                log.info("--------------ETL 4-----------------");

                log.info("find not evaluation normal end orders etl is start!");

                // 查询正常结束的订单
                List<Orders> notEvaluationNormalEndOrderList = findNotEvaluationNormalEndOrders();

                log.info("not evaluation normal end order list size :" + notEvaluationNormalEndOrderList.size());

                if (CollectionUtils.isEmpty(notEvaluationNormalEndOrderList)) {

                    log.info("orders push etl not get any id ,sleep " + SLEEP_MILLISECOND + " ms ");

//                    Thread.sleep(SLEEP_MILLISECOND);

                }else {
                    processOrder(notEvaluationNormalEndOrderList);
                }
                Thread.sleep(SLEEP_MILLISECOND);


            } catch (Throwable t) {

                t.printStackTrace();

                Thread.sleep(SLEEP_MILLISECOND);

                log.error("process goods bytime status error ,sleep " + t.getMessage());

            }

        }

    }


    /**
     * 查询24小时内未评论正常结束订单
     * @return
     */
    private List<Orders> findNotEvaluationNormalEndOrders() {

        log.info("============------------===============");

        log.info("find not evaluation normal end order method start!!!");

        List<Orders> notEvaluationNormalEndOrderList = new ArrayList();

        List<Orders> notEvaluationNormalEndOrderResultList = new ArrayList<>();

        Map<String, Object> conditions = DynamicUtil.getNotEvaluationNormalEntOrders();

        log.info("get normal end order params ；" + conditions);

        try {

            List<Long> notEvaluationNormalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class,
                    conditions,
                    0, TASK_LEN);

            if (CollectionUtils.isNotEmpty(notEvaluationNormalEndOrderIds)) {

                notEvaluationNormalEndOrderList = this.ordersService.getObjectsByIds(notEvaluationNormalEndOrderIds);

            }

            for (Orders orders : notEvaluationNormalEndOrderList) {

                Long interval = System.currentTimeMillis() - orders.getEndOfOrderAt();

                log.info("interval is :" + interval);

                if (interval >= Orders.ONE_DAY) {

                    notEvaluationNormalEndOrderResultList.add(orders);

                }

            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
        }

        return notEvaluationNormalEndOrderResultList;
    }


    /**
     * 给出租人转账
     * @param notEvaluationNormalEndOrderList
     * @throws ServiceException
     * @throws ServiceDaoException
     * @throws InterruptedException
     * @throws IOException
     */
    private void processOrder(List<Orders> notEvaluationNormalEndOrderList) throws Exception {

        log.info("***********************************");

        log.info("Transfer to lessor");

        boolean b = ordersService.randomSetUserCommentCount(notEvaluationNormalEndOrderList);

        log.info(b);

    }


    public OrdersService getOrdersService() {
        return ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public UserCommentRelationService getUserCommentRelationService() {
        return userCommentRelationService;
    }

    public UserCommentCountService getUserCommentCountService() {
        return userCommentCountService;
    }

    public void setUserCommentRelationService(UserCommentRelationService userCommentRelationService) {
        this.userCommentRelationService = userCommentRelationService;
    }

    public void setUserCommentCountService(UserCommentCountService userCommentCountService) {
        this.userCommentCountService = userCommentCountService;
    }

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    private void getCommentCount(List<String> commentList, Long uid) throws Exception {


        List<Long> userCommentCountIds = userCommentCountService.getUserCommentCountIdsByUid(uid, 0, 10);

        if (CollectionUtils.isEmpty(userCommentCountIds)) {

            UserCommentCount userCount = new UserCommentCount();

            log.info("-------------------" + userCount);

            CommentCountUtils.countComment(commentList, userCount);

            userCount.setUid(uid);

            Long userCommentCountId = userCommentCountService.insert(userCount);

            log.info("user comment count id is :" + userCommentCountId);

        } else {

            Long userCommentCountId = userCommentCountIds.get(0);

            UserCommentCount userCommentCount = userCommentCountService.getObjectById(userCommentCountId);

            CommentCountUtils.countComment(commentList, userCommentCount);

            boolean b = userCommentCountService.update(userCommentCount);

            if (b) {

                log.info("userCommentCount update success");

            } else {

                log.info("userCommentCount update fail");

                throw new Exception("update UserCommentCount Exception");
            }

        }

    }

}
