package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.qding.community.common.weixin.service.WeiXinService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author cjsff
 * 2018/7/3
 * 进行中订单，承租人申请终止订单，出租人在3小时内未做出回应，自动同意
 */
public class OrdersTerminationUnconfirmedEtl {

    private static final Log log = LogFactory.getLog(OrdersTerminationUnconfirmedEtl.class);

    private OrdersService ordersService;

    @Autowired
    private WeiXinService weixinService;

    /**
     * 一次任务检测多少条数据
     */
    private static final int TASK_LEN = 100;

    /**
     * 空转任务间隔休息毫秒数
     */
    private static final long SLEEP_MILLISECOND = 15000;

    private Long interval = 2000L;

    public OrdersTerminationUnconfirmedEtl() {
        super();
    }

    public void process() throws InterruptedException {

        while (true) {

            try {

                log.info("--------------ETL 5-----------------");

                log.info("find termination unconfirmed orders etl is start!");

                // 查询正常结束的订单
                List<Orders> normalEndOrderList = findNormalEndOrders();

                log.info("normal end order list size :" + normalEndOrderList.size());

                if (CollectionUtils.isEmpty(normalEndOrderList)) {

                    log.info("orders push etl not get any id ,sleep " + SLEEP_MILLISECOND + " ms ");

//                    Thread.sleep(SLEEP_MILLISECOND);

                }else {
                    processOrder(normalEndOrderList);
                }
                Thread.sleep(SLEEP_MILLISECOND);


            } catch (Throwable t) {

                t.printStackTrace();

                Thread.sleep(SLEEP_MILLISECOND);

                log.error("process goods bytime status error ,sleep " + t.getMessage());

            }

        }

    }


    /**
     * 进行中订单，承租人申请终止订单，出租人在3小时内未做出回应，自动同意
     * @return
     */
    private List<Orders> findNormalEndOrders() {

        log.info("============------------===============");

        log.info("find normal end order method start!!!");

        List<Orders> normalEndOrderList = new ArrayList();

        List<Orders> terminationUnconfirmedOrderList = new ArrayList<>();

        Map<String, Object> conditions = DynamicUtil.getOrdersTerminationUnconfirmedList();

        log.info("get normal end order params ；" + conditions);

        try {

            List<Long> normalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions,
                    0, TASK_LEN);

            if (CollectionUtils.isNotEmpty(normalEndOrderIds)) {

                normalEndOrderList = this.ordersService.getObjectsByIds(normalEndOrderIds);

                for (Orders orders : normalEndOrderList) {

                    Long interval = System.currentTimeMillis() - orders.getRefundAt();

                    if (interval >= Orders.THREE_HOURS) {

                        terminationUnconfirmedOrderList.add(orders);

                    }

                }

            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
        }

        return terminationUnconfirmedOrderList;
    }


    /**
     * 给出租人转账
     * @param normaoEndOrderList
     * @throws ServiceException
     * @throws ServiceDaoException
     * @throws InterruptedException
     * @throws IOException
     */
    private void processOrder(List<Orders> normaoEndOrderList) throws ServiceException, ServiceDaoException,
            InterruptedException,
            IOException {

        log.info("***********************************");

        log.info("Transfer to lessor");

        if (CollectionUtils.isNotEmpty(normaoEndOrderList)) {

            for (Orders orders : normaoEndOrderList) {

                orders.setStatus(Orders.PROCESSING_LESSEE_REFUND_SYSTEM_REFUND);

                // TODO 给出租人转账

            }

            boolean boo = ordersService.updateList(normaoEndOrderList);

            if (boo) {

                log.info("order update status success");

            } else {

                log.info("order update status fail");

                log.info("-------------------------");

            }

        }

    }


    public OrdersService getOrdersService() {
        return ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

}
