package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.base.Joiner;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.qding.community.common.weixin.service.WeiXinService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author cjsff
 */
public class OrdersFindLessorIsNotConfirmedEtl {

    private static final Log log = LogFactory.getLog(OrdersFindLessorIsNotConfirmedEtl.class);

    private OrdersService ordersService;

    @Autowired
    private WeiXinService weixinService;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    /**
     * 一次任务检测多少条数据
     */
    private static final int TASK_LEN = 100;

    /**
     * 空转任务间隔休息毫秒数
     */
    private static final long SLEEP_MILLISECOND = 15000;

    private Long interval = 2000L;

    public OrdersFindLessorIsNotConfirmedEtl() {
        super();
    }

    public void process() throws InterruptedException {

        while (true) {

            try {

                log.info("--------------ETL 1-----------------");

                log.info("find lessor is not confirmed etl is start!");

                // 出租人在订单开始时间前未点击确认订单，则订单自动取消，退款到账后，订单消失

                List<Orders> endAutoOrderList = getEndAutoList();

                log.info("end auto order list size :" + endAutoOrderList.size());

                if (CollectionUtils.isEmpty(endAutoOrderList)) {

                    log.info("orders push etl not get any id ,sleep " + SLEEP_MILLISECOND + " ms ");

//                    Thread.sleep(SLEEP_MILLISECOND);

                }else {
                    processOrder(endAutoOrderList);
                }
                Thread.sleep(SLEEP_MILLISECOND);


            } catch (Throwable t) {

                t.printStackTrace();

                Thread.sleep(SLEEP_MILLISECOND);

                log.error("process goods bytime status error ,sleep " + t.getMessage());

            }

        }

    }


    /**
     * 出租人在订单开始时间前未点击确认订单，则订单自动取消，退款到账后，订单消失
     *
     * @return
     */
    private List<Orders> getEndAutoList() {

        log.info("end auto order search start!!!");

        List<Orders> endAutoOrders = new ArrayList();

        List<Orders> resultEndAutoOrder = new ArrayList<>();

        Map<String, Object> conditions = DynamicUtil.getAbnormalOrders();

        log.info("get end auto order params ；" + conditions);

        try {

            List<Long> endAutoOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions,
                    0, TASK_LEN);

            log.info("end auto orders is :" + endAutoOrderIds);

            if (CollectionUtils.isNotEmpty(endAutoOrderIds)) {

                endAutoOrders = this.ordersService.getObjectsByIds(endAutoOrderIds);

            }

            for (Orders orders : endAutoOrders) {

                if (orders.getLeaseStartAt() < System.currentTimeMillis()) {

                    resultEndAutoOrder.add(orders);

                }

            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
        }

        return resultEndAutoOrder;
    }


    /**
     * 取消订单
     * @param endAutoOrder
     * @throws ServiceException
     * @throws ServiceDaoException
     * @throws InterruptedException
     * @throws IOException
     */
    private void processOrder(List<Orders> endAutoOrder) throws ServiceException, ServiceDaoException,
            InterruptedException,
            IOException {

        log.info("Cancel overtime order");

        List<Long> uids = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(endAutoOrder)) {

            for (Orders orders : endAutoOrder) {

                log.info("hello,world");

                log.info("=================================");

                orders.setStatus(Orders.ORDER_TIME_OUT_CANCEL);

                log.info("==============(((((((()))))))))");

                log.info(orders.getLesseeId());

                log.info(orders.getLessorId());

                uids.add(orders.getLessorId());

                uids.add(orders.getLesseeId());



                // TODO 给承租人退款

            }

            String uidListToString = Joiner.on(",").join(uids);

            int lesseeUpdate = jdbcTemplate.update("UPDATE user SET orders_status=1 where id in (" + uidListToString + ")");

            log.info("----------------" + lesseeUpdate);

            ordersService.updateList(endAutoOrder);

        }

    }


    public OrdersService getOrdersService() {
        return ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }


    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }


}

