/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.sms.service.SMSSendService;
import com.ptteng.common.sms.service.VoiceSendService;
import com.ptteng.rent.common.model.Sms;
import com.ptteng.rent.common.service.SmsService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsServiceImpl
extends BaseDaoServiceImpl
implements SmsService {
    private static final Log log = LogFactory.getLog(SmsServiceImpl.class);
    private Map<String, String> type_template = new HashMap<String, String>();
    private SMSSendService smsSendService;
    private VoiceSendService voiceSendService;
    private String registered = "\u6ce8\u518c\u8d26\u53f7";
    private String password = "\u627e\u56de\u5bc6\u7801";

    public SMSSendService getSmsSendService() {
        return this.smsSendService;
    }

    public void setSmsSendService(SMSSendService smsSendService) {
        this.smsSendService = smsSendService;
    }

    public Map<String, String> getType_template() {
        return this.type_template;
    }

    public void setType_template(Map<String, String> type_template) {
        this.type_template = type_template;
    }

    public VoiceSendService getVoiceSendService() {
        return this.voiceSendService;
    }

    public void setVoiceSendService(VoiceSendService voiceSendService) {
        this.voiceSendService = voiceSendService;
    }

    public Long insert(Sms sms) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + sms));
        if (sms == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        sms.setCreateAt(Long.valueOf(currentTimeMillis));
        sms.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)sms);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + sms));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Sms> insertList(List<Sms> smsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (smsList == null ? "null" : Integer.valueOf(smsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(smsList)) {
            return new ArrayList<Sms>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sms sms : smsList) {
            sms.setCreateAt(Long.valueOf(currentTimeMillis));
            sms.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(smsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + smsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Sms.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Sms sms) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (sms == null ? "null" : sms.getId())));
        boolean result = false;
        if (sms == null) {
            return true;
        }
        sms.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)sms);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + sms));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + sms));
        }
        return result;
    }

    public boolean updateList(List<Sms> smsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (smsList == null ? "null" : Integer.valueOf(smsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(smsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sms sms : smsList) {
            sms.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(smsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + smsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + smsList.size()));
        return result;
    }

    public Sms getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Sms sms = null;
        if (id == null) {
            return sms;
        }
        try {
            sms = (Sms)this.dao.get(Sms.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return sms;
    }

    public List<Sms> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List sms = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Sms>();
        }
        try {
            sms = this.dao.getList(Sms.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (sms == null ? "null" : Integer.valueOf(sms.size()))));
        return sms;
    }

    public Long getSmsIdByMobileAndType(String mobile, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by mobile,type  : " + mobile + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getSmsIdByMobileAndType", new Object[]{mobile, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mobile,type  : " + mobile + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getSmsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSmsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSmsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSmsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSmsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String sendMsg(String phone, String type) throws ServiceException, ServiceDaoException {
        if (!this.type_template.containsKey(type)) {
            log.info((Object)(type + " is not limit "));
            return "invalideType";
        }
        String code = "";
        String codeMessage = "";
        int count = 0;
        Sms sms = new Sms();
        Long smsId = this.getSmsIdByMobileAndType(phone, type);
        log.info((Object)("sms id is :" + smsId));
        if (smsId != null) {
            sms = this.getObjectById(smsId);
            SimpleDateFormat formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            log.info((Object)("current time millis is :" + ftime));
            String stime = formatter.format(sms.getSendAt());
            log.info((Object)("sms send time is :" + stime));
            if (!ftime.equals(stime)) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            log.info((Object)("sms send count is :" + intNum));
            String num = "" + intNum;
            log.info((Object)("========== num is :" + num));
            if (sms.getCount() < 5) {
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                log.info((Object)("delay is :" + delay));
                if (delay <= 900000L) {
                    log.info((Object)"15\u5206\u949f\u5185\u53d1\u9001\u76f8\u540c\u9a8c\u8bc1\u7801");
                    code = sms.getMessage();
                    log.info((Object)("sms info is :" + code));
                    String returnString = "";
                    if (type.equals("register")) {
                        returnString = this.sendSms(phone, type, new String[]{"\u3010\u79df\u4eba\u5c0f\u7a0b\u5e8f\u3011\u60a8\u7684\u6ce8\u518c\u9a8c\u8bc1\u7801\u662f" + code + ",\u6709\u6548\u65f6\u95f4\u4e3a5\u5206\u949f\u3002\u82e5\u975e\u60a8\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u672c\u6d88\u606f\u3002\u5173\u6ce8\u6211\u4eec\u7684\u516c\u4f17\u53f7\u201c\u79df\u4eba\u5c0f\u7a0b\u5e8f\u201d\uff0c\u83b7\u53d6\u66f4\u591a\u7cbe\u5f69\u5185\u5bb9"});
                    }
                    log.info((Object)("\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u503c\uff1a" + returnString));
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    log.info((Object)"\u4fe1\u606f\u53d1\u9001\u6210\u529f");
                } else {
                    Random rand = new Random();
                    for (int i = 0; i < 6; ++i) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();
                    log.info((Object)("code is :" + code));
                    String returnString = "";
                    if (type.equals("register")) {
                        returnString = this.sendSms(phone, type, new String[]{"\u3010\u79df\u4eba\u5c0f\u7a0b\u5e8f\u3011\u60a8\u7684\u6ce8\u518c\u9a8c\u8bc1\u7801\u662f" + code + ",\u6709\u6548\u65f6\u95f4\u4e3a5\u5206\u949f\u3002\u82e5\u975e\u60a8\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u672c\u6d88\u606f\u3002\u5173\u6ce8\u6211\u4eec\u7684\u516c\u4f17\u53f7\u201c\u79df\u4eba\u5c0f\u7a0b\u5e8f\u201d\uff0c\u83b7\u53d6\u66f4\u591a\u7cbe\u5f69\u5185\u5bb9"});
                    }
                    log.info((Object)("\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u503c\uff1a" + returnString));
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    sms.setMessage(code);
                    log.info((Object)"\u8d85\u8fc730\u5206\u949f\u53d1\u9001\u65b0\u9a8c\u8bc1\u7801");
                }
                this.update(sms);
                return "";
            }
            log.info((Object)"count > 5 ");
            return "smsMoreThan5";
        }
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            code = code + rand.nextInt(10);
        }
        code = code.trim();
        sms.setCount(0);
        int intNum = sms.getCount() + 1;
        String num = "" + intNum;
        String returnString = "";
        try {
            if (type.equals("register")) {
                returnString = this.sendSms(phone, type, new String[]{"\u3010\u79df\u4eba\u5c0f\u7a0b\u5e8f\u3011\u60a8\u7684\u6ce8\u518c\u9a8c\u8bc1\u7801\u662f" + code + ",\u6709\u6548\u65f6\u95f4\u4e3a5\u5206\u949f\u3002\u82e5\u975e\u60a8\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u672c\u6d88\u606f\u3002\u5173\u6ce8\u6211\u4eec\u7684\u516c\u4f17\u53f7\u201c\u79df\u4eba\u5c0f\u7a0b\u5e8f\u201d\uff0c\u83b7\u53d6\u66f4\u591a\u7cbe\u5f69\u5185\u5bb9"});
            }
            log.info((Object)("\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u503c\uff1a" + returnString));
            ++count;
            sms.setMobile(phone);
            sms.setType(type);
            sms.setMessage(code);
            sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
            sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
            sms.setCount(count);
            Long ms = this.insert(sms);
            log.info((Object)("\u53d1\u9001\u6210\u529f\uff01 \u4fe1\u606f\u4fdd\u5b58\u7ed3\u679c\uff1a" + ms));
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String sendRepaymentMessage(String phone, String type, String repaymentAmount, String signingAt) {
        String returnString = this.sendSms(phone, type, new String[]{"\u3010\u661f\u5ba0\u533b\u7597\u3011\u5c0a\u656c\u7684\u987e\u5ba2\uff0c\u60a8\u5f53\u6708\u9700\u8fd8\u6b3e\u989d" + repaymentAmount + ".00\u5143\uff0c\u4e3a\u4e86\u4e0d\u5f71\u54cd\u60a8\u7684\u5f81\u4fe1\u8bb0\u5f55\uff0c\u8bf7\u4e8e" + signingAt + "\u524d\u8fd8\u6b3e\uff0c\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u4e13\u804c\u5ba2\u670dxxxxxxxx"});
        log.info((Object)("return is \uff1b" + returnString));
        return "";
    }

    private String sendSms(String phone, String type, String[] params) {
        String template = this.type_template.get(type);
        log.info((Object)(phone + " and type is " + type + " params " + Arrays.asList(params) + " template " + template));
        String returnString = null;
        try {
            returnString = this.smsSendService.sendSMSByTemplate(phone, template, params);
            return returnString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnString;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String sendVoice(String phone, String type) throws ServiceException, ServiceDaoException {
        if (!this.type_template.containsKey(type)) {
            log.info((Object)(type + " is not limit "));
            return "invalideType";
        }
        String code = "";
        int count = 0;
        Sms sms = new Sms();
        Long smsId = this.getSmsIdByMobileAndType(phone, type);
        if (smsId != null) {
            String stime;
            sms = this.getObjectById(smsId);
            SimpleDateFormat formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            if (!ftime.equals(stime = formatter.format(sms.getSendAt()))) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;
            if (sms.getCount() < 5) {
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 1800000L) {
                    log.info((Object)"30\u5206\u949f\u5185\u53d1\u9001\u76f8\u540c\u9a8c\u8bc1\u7801");
                    code = sms.getMessage();
                    String sendResult = this.voiceSendService.sendVoice(phone, code);
                    log.info((Object)("sendResult\uff1a" + sendResult));
                    if (sendResult.startsWith("Error")) {
                        return "sendError";
                    }
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    log.info((Object)"\u8bed\u97f3\u53d1\u9001\u6210\u529f");
                } else {
                    Random rand = new Random();
                    for (int i = 0; i < 6; ++i) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();
                    String sendResult = this.voiceSendService.sendVoice(phone, code);
                    log.info((Object)("sendResult\uff1a" + sendResult));
                    if (sendResult.startsWith("Error")) {
                        return "sendError";
                    }
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    sms.setMessage(code);
                    log.info((Object)"\u8d85\u8fc730\u5206\u949f\u53d1\u9001\u65b0\u9a8c\u8bc1\u7801");
                }
                this.update(sms);
                return "";
            }
            log.info((Object)"count > 5 ");
            return "smsMoreThan5";
        }
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            code = code + rand.nextInt(10);
        }
        code = code.trim();
        sms.setCount(0);
        int intNum = sms.getCount() + 1;
        String num = "" + intNum;
        try {
            String sendResult = this.voiceSendService.sendVoice(phone, code);
            log.info((Object)("sendResult\uff1a" + sendResult));
            if (sendResult.startsWith("Error")) {
                return "sendError";
            }
            ++count;
            sms.setMobile(phone);
            sms.setType(type);
            sms.setMessage(code);
            sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
            sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
            sms.setCount(count);
            Long ms = this.insert(sms);
            log.info((Object)("\u53d1\u9001\u6210\u529f\uff01 \u4fdd\u5b58\u7ed3\u679c\uff1a" + ms));
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

