package com.ptteng.rent.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.rent.admin.service.ManagerService;
import com.ptteng.rent.admin.utils.DynamicUtil;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.community.common.weixin.service.WeiXinService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * User  crud
 *
 * @author ss127
 * @date 2018/6/7
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private UserService userService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;


    /**
     * 用户详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.GET)
    public String getUser(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("url is : /a/u/user/" + id);

        if (DataUtils.isNullOrEmpty(id)) {

            log.info("user id is :" + id);

        }

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -6003);
        }

        return "/rent-user-service/user/json/userDetailJson";
    }


    /**
     * 编辑用户
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/{id}", method = RequestMethod.PUT)
    public String updateUserJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, String feeCap, String tag, Integer status, Long recommenderId) throws Exception {

        log.info("url is : /a/u/user/" + id + "?feeCap=" + feeCap + "&tag=" + tag + "&status=" + status + "&recommenderId=" + recommenderId);

        try {

            User user = userService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(user)) {

                log.info("user is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            if (DataUtils.isNotNullOrEmpty(feeCap)) {

                user.setFeeCap(feeCap);

            }

            if (DataUtils.isNotNullOrEmpty(tag)) {

                user.setTag(tag);

            }

            if (DataUtils.isNotNullOrEmpty(status)) {

                user.setStatus(status);

            }

            if (DataUtils.isNotNullOrEmpty(recommenderId)) {

                user.setRecommenderId(recommenderId);

            }


            boolean b = userService.update(user);

            if (b) {

                log.info("user update type is success");

            } else {

                log.info("user update type is fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update user error,id is  " + id);
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }

    /**
     * 用户列表
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/user/search", method = RequestMethod.GET)
    public String getUserList¢(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Integer page,
                               Integer size, Integer sex, String positioning, Long id, String nick, Integer status, String mobile, Integer userType
            , String tag, Long startAt, Long endAt) throws Exception {

        log.info("url is :/a/u/user/search?sex=" + sex + "&tag=" + tag + "&positioning=" + positioning + "&page=" + page + "&size=" + size + "&id=" + id + "&nick=" + nick
                + "&status=" + status + "&mobile=" + mobile + "&userType=" + userType + "&startAt=" + startAt + "&endAt=" + endAt);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;

        Integer total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> usersParams = DynamicUtil.getUserList(sex, positioning, id, nick, status, mobile, userType, tag, startAt, endAt, false);

            log.info("usersParams is :" + usersParams);

            List<Long> uids = userService.getIdsByDynamicCondition(User.class, usersParams, start, size);

            log.info("uid size is :" + uids.size());

            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(uids)) {

                userList = userService.getObjectsByIds(uids);

                if (userList.size() >= size) {

                    next = true;

                }

            }

            Map<String, Object> countUserParam = DynamicUtil.getUserList(sex, positioning, id, nick, status, mobile, userType, tag, startAt, endAt, true);

            log.info("countUserParam is :" + countUserParam);

            List<Long> countUids = userService.getIdsByDynamicCondition(User.class, usersParams, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isNotEmpty(countUids)) {

                total = countUids.size();

                log.info("user total is :" + total);

            }

            log.info("countUids size is :" + countUids.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("next", next);
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/user/json/userListJson";
    }


}

