package com.ptteng.rent.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.rent.admin.utils.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Orders  crud
 *
 * @author ss127
 * @date 2018/6/7
 */
@Controller
public class OrdersController {
    private static final Log log = LogFactory.getLog(OrdersController.class);

    @Autowired
    private OrdersService ordersService;
    @Autowired
    private UserService userService;



    @RequestMapping(value = "/a/u/order/search", method = RequestMethod.GET)
    public String getOrdersIdsByLessorIdJsonList(HttpServletRequest request,
                                                 HttpServletResponse response, ModelMap model, Integer page,
                                                 Integer size,Long id, Long lessorId, String positioning, Long
                                                             lesseeId, Integer status, Long startAt, Long endAt, Long dateStarAt
            , Long dateEndAt, Integer sex) throws Exception {

        log.info("url is : /a/u/order/search?lessorId=" + lessorId + "&positioning=" + positioning + "&lesseeId=" + lesseeId + "&status=" + status + "&startAt=" + startAt + "&endAt" + endAt
                + "&dateStarAt=" + dateStarAt + "&dateEndAt=" + dateEndAt + "&sex=" + sex + "$id=" + id);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;

        Long total = 0L;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> ordersParams = DynamicUtil.searchOrders(id,lessorId, positioning, lesseeId, status,
                    startAt, endAt, false);

            log.info("orders params is :" + ordersParams);

            List<Long> oids = ordersService.getIdsByDynamicCondition(Orders.class, ordersParams, start, size);

            log.info("oids size is :" + oids.size());

            List<Orders> ordersList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(oids)) {

                ordersList = ordersService.getObjectsByIds(oids);

                if (ordersList.size() >= size) {

                    next = true;

                }

            }

            Map<String, Object> countOrdersParams = DynamicUtil.searchOrders(id,lessorId, positioning, lesseeId,
                    status, startAt, endAt, true);

            log.info("countOrdersParams is :" + countOrdersParams);

            List<Long> countOrders = ordersService.getIdsByDynamicCondition(Orders.class, countOrdersParams, 0, Integer.MAX_VALUE);

            log.info("countOrders size is :" + countOrders.size());

            log.info("-----------------------------" + countOrders.get(0));

            if (CollectionUtils.isNotEmpty(countOrders)) {

                total = countOrders.get(0);

                log.info("countOrders is :" + total);

            }

            log.info("countOrders size is :" + countOrders.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("ordersList", ordersList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get orders list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/orders/json/ordersListJson";
    }

    /**
     * 订单详情
     *
     * @param request
     * @param response
     * @param model
     * @param oid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/order/{oid}", method = RequestMethod.GET)
    public String getOrdersJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long oid)
            throws Exception {

        log.info("url is : /a/u/order/" + oid);

        if (DataUtils.isNullOrEmpty(oid)) {

            log.info("oid  is :" + oid);

            model.addAttribute("code", -1000);

            return "/common/success";

        }

        try {

            Orders orders = ordersService.getObjectById(oid);

            if (DataUtils.isNullOrEmpty(orders)) {

                log.info("order is not exist");

                model.addAttribute("code", -30000);

                return "/common/success";

            }

            User lessee = userService.getObjectById(orders.getLesseeId());

            if (DataUtils.isNullOrEmpty(lessee)) {

                log.info("user is null,user id is :" + orders.getLesseeId());

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            User lessor = userService.getObjectById(orders.getLessorId());

            if (DataUtils.isNullOrEmpty(lessor)) {

                log.info("lessor is null,user id is :" + orders.getLessorId());

                model.addAttribute("code", -2011);

                return "/common/success";

            }


            model.addAttribute("code", 0);
            model.addAttribute("orders", orders);
            model.addAttribute("lesseeNick", lessee.getNick());
            model.addAttribute("lessorNick", lessor.getNick());

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get orders error,id is  " + oid);
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/orders/json/ordersDetailJson";
    }


    /**
     * 财务管理列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param lessorId    出租人ID
     * @param positioning 出租人当前定位
     * @param status      订单状态
     * @param startAt     订单开始时间
     * @param endAt       订单结束时间
     * @param sex         出租人性别
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/finance/search", method = RequestMethod.GET)
    public String getFinance(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, Integer page,
                             Integer size, Long lessorId, String positioning, Integer status, Long startAt, Long endAt, Integer sex) throws Exception {

        log.info("url is : /a/u/order/search?lessorId=" + lessorId + "&positioning=" + positioning + "&status=" + status + "&startAt=" + startAt + "&endAt" + endAt + "&sex=" + sex);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;

        Integer total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> ordersParams = DynamicUtil.financeOrders(lessorId, positioning, status, startAt, endAt, sex, false);

            log.info("orders params is :" + ordersParams);

            List<Long> oids = ordersService.getIdsByDynamicCondition(Orders.class, ordersParams, start, size);

            log.info("oids size is :" + oids.size());

            List<Orders> ordersList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(oids)) {

                ordersList = ordersService.getObjectsByIds(oids);

                if (ordersList.size() >= size) {

                    next = true;

                }

            }

            List<Long> lessorIds = MyListUtil.getDistinctList(Orders.class.getDeclaredField("lessorId"), ordersList);

            log.info("lessorIds size is :" + lessorIds.size());

            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(lessorIds)) {

                userList = userService.getObjectsByIds(lessorIds);

            }

            Map<String, Object> countOrdersParams = DynamicUtil.financeOrders(lessorId, positioning, status, startAt, endAt, sex, true);

            log.info("countOrdersParams is :" + countOrdersParams);

            List<Long> countOrders = ordersService.getIdsByDynamicCondition(Orders.class, countOrdersParams, 0, Integer.MAX_VALUE);

            log.info("countOrders size is :" + countOrders.size());

            if (CollectionUtils.isNotEmpty(countOrders)) {

                total = countOrders.get(0).intValue();

                log.info("countOrders is :" + total);

            }

            log.info("countOrders size is :" + countOrders.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("ordersList", ordersList);
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get orders list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/orders/json/ordersListJson";
    }

    /**
     * 财务明细列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param dateStarAt
     * @param dateEndAt
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/income/search", method = RequestMethod.GET)
    public String getFinanceForDate(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Long dateStarAt, Long dateEndAt) throws Exception {

        log.info("url is : /a/u/income/search?dateStarAt=" + dateStarAt + "&dateEndAt=" + dateEndAt);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;

        Long total = 0L;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> ordersParams = DynamicUtil.incomeOrders(dateStarAt, dateEndAt, false);

            log.info("orders params is :" + ordersParams);

            List<Long> oids = ordersService.getIdsByDynamicCondition(Orders.class, ordersParams, start, size);

            log.info("oids size is :" + oids.size());

            List<Orders> ordersList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(oids)) {

                ordersList = ordersService.getObjectsByIds(oids);

                if (ordersList.size() >= size) {

                    next = true;

                }

            }

            List<Long> lessorIds = MyListUtil.getDistinctList(Orders.class.getDeclaredField("lessorId"), ordersList);

            log.info("lessorIds size is :" + lessorIds.size());

            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(lessorIds)) {

                userList = userService.getObjectsByIds(lessorIds);

            }

            BigDecimal totalRevenue = new BigDecimal("0");

            BigDecimal totalRefund = new BigDecimal("0");

            List<Long> totalRevenuePriceIds = ordersService.getIdsByDynamicCondition(Orders.class, ordersParams, 0,
                    Integer.MAX_VALUE);

            log.info("totalRevenuePriceIds size is :" + totalRevenuePriceIds);

            if (CollectionUtils.isNotEmpty(totalRevenuePriceIds)) {

                List<Orders> totalOrders = ordersService.getObjectsByIds(totalRevenuePriceIds);

                for (Orders orders : totalOrders) {

                    log.info("===========================================");

                    log.info("status is :" + orders.getStatus());
                    //正常结束订单||
                    if (Orders.COMPLETE_THE_ORDER_NORMALLY.equals(orders.getStatus())|| Orders.TRANSFERRED.equals(orders.getStatus())) {

                        totalRevenue = totalRevenue.add(orders.getPrice());

                        log.info("total revenue is :" + totalRevenue);

                    } else if (Orders.REFUNDED.equals(orders.getStatus())) {

                        totalRefund = totalRefund.add(orders.getPrice());

                    }

                }

            }

            log.info("total revenue is :" + totalRevenue);

            log.info("total refund is :" + totalRefund);


            Map<String, Object> countOrdersParams = DynamicUtil.incomeOrders(dateStarAt, dateEndAt, true);

            log.info("countOrdersParams is :" + countOrdersParams);

            List<Long> countOrders = ordersService.getIdsByDynamicCondition(Orders.class, countOrdersParams, 0, Integer.MAX_VALUE);

            log.info("countOrders size is :" + countOrders.size());

            if (CollectionUtils.isNotEmpty(countOrders)) {

                total = countOrders.get(0);

                log.info("countOrders is :" + total);

            }

            Long totalOrders = total;

            log.info("totalOrders is :" + totalOrders);

            log.info("countOrders size is :" + countOrders.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("totalOrders", totalOrders);
            model.addAttribute("totalRevenue", totalRevenue);
            model.addAttribute("totalRefund", totalRefund);
            model.addAttribute("ordersList", ordersList);
            model.addAttribute("userList", userList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get orders list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/orders/json/income";
    }


}

