package com.ptteng.rent.admin.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by ouyang on 2016/12/16.
 */
public class CheckDataUtil {

    /**
     * 校验字符串为合法手机号码
     * 1-字符串不为空
     * 2-第一位为“1”
     * 3-纯数字
     * 4-11位字符串
     * @param mobile
     * @return true-正常手机号 false-非法手机号
     */
    public static boolean checkMobile(String mobile) {

        if (StringUtils.isBlank(mobile)) {
            return false;
        }

        if ("1".equals(mobile.charAt(0))) {
            return false;
        }

        int size = mobile.length();
        for (int i = 1; i < size; i++) {
            if (CheckDataUtil.isNotDigit(mobile.charAt(i))) {
                return false;
            }
        }

        return mobile.length() == 11 ? true : false;
    }




    public static boolean isNotDigit(char c) {
        return !(Character.isDigit(c));
    }

    public static boolean isNotNull(Object object) {
        return !(isNull(object));
    }

    public static boolean isNull(Object object) {
        return null == object?true:false;
    }

    public static boolean notEqual(Long num1, Long num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return !(num1.equals(num2));
    }

    public static boolean notEqual(Integer num1, Integer num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return !(num1.equals(num2));
    }

    public static boolean equal(Long num1, Long num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return num1.equals(num2);
    }

    public static boolean equal(Integer num1, Integer num2) {
        if (isNull(num1) || isNull(num2)) {
            return false;
        }
        return num1.equals(num2);
    }



}
