package com.ptteng.rent.admin.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.rent.admin.model.Constant;
import com.ptteng.rent.admin.model.Manager;
import com.ptteng.rent.admin.service.ConstantService;
import com.ptteng.rent.admin.service.ManagerService;
import com.ptteng.rent.admin.utils.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.model.Withdraw;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserManagerRelationService;
import com.ptteng.rent.user.service.UserService;
import com.ptteng.rent.user.service.WithdrawService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Controller
public class UserManagerRelationController {

    private static final Log log = LogFactory.getLog(UserManagerRelationController.class);

    @Autowired
    private UserManagerRelationService userManagerRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrdersService ordersService;
    @Autowired
    private WithdrawService withdrawService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    /**
     * 艺人管理列表
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @param id
     * @param nick
     * @param status
     * @param mobile
     * @param startAt
     * @param endAt
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/broker/search", method = RequestMethod.GET)
    public String getOrdersJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Integer page,
                                Integer size, Long mid, Long id, String nick, Integer status, String mobile, Long startAt, Long endAt)
            throws Exception {

        log.info("url is : /a/u/broker/search?id" + id + "&nick=" + nick + "&status=" + status + "&mobile=" + mobile + "&startAt=" + startAt + "&endAt=" + endAt + "&mid=" + mid);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        if (DataUtils.isNullOrEmpty(mid)) {

            log.info("mid is null");

            model.addAttribute("code", -40000);

            return "/common/success";

        }

        boolean next = false;

        Integer total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Manager manager = (Manager) request.getAttribute("manager");

            Map<String, Object> usersParams = DynamicUtil.getUserFromBrokerId(mid, id, nick, status, mobile, startAt, endAt, false);

            log.info("usersParams is :" + usersParams);

            List<Long> uids = userService.getIdsByDynamicCondition(User.class, usersParams, start, size);

            log.info("uid is :" + uids);

            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(uids)) {

                userList = userService.getObjectsByIds(uids);

                if (userList.size() >= size) {

                    next = true;

                }

            }
            //获取艺人列表
            Map<String, Object> countUserParam = DynamicUtil.getUserFromBrokerId(mid, id, nick, status, mobile, startAt, endAt, true);

            log.info("countUserParam is :" + countUserParam);

            List<Long> countUids = userService.getIdsByDynamicCondition(User.class, usersParams, 0, Integer.MAX_VALUE);

            Integer totalUser = 0;

            if (CollectionUtils.isNotEmpty(countUids)) {

                total = countUids.size();

                log.info("user total is :" + total);

                totalUser = total;

            }

            log.info("countUids size is :" + countUids.size());

            Map<String, Object> getLessorForMidParams = DynamicUtil.getLessorForMid(mid);

            log.info("get lessor for mid params is :" + getLessorForMidParams);

            List<Long> orderIds = ordersService.getIdsByDynamicCondition(Orders.class, getLessorForMidParams, 0, Integer.MAX_VALUE);
            //获取出租人正常完成未提现订单
            String getBrokerLessorOrderIds = "select id from orders where mid = " + mid + " and status = " + Orders
                    .REFUNDED;

            List<Map<String, Object>> getBrokerLessorOrderIdsResultMapList = jdbcTemplate.queryForList(getBrokerLessorOrderIds);

            log.info("getBrokerLessorOrderIdsResultMapList size is :" + getBrokerLessorOrderIdsResultMapList.size());

            List<Long> brokerLessorOrderIds = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(getBrokerLessorOrderIdsResultMapList)) {

                for (Map<String, Object> lesseeId : getBrokerLessorOrderIdsResultMapList) {

                    brokerLessorOrderIds.add((Long) lesseeId.get("id"));

                }

            }

            log.info("brokerLessorOrderIds is :" + brokerLessorOrderIds);

            List<Orders> ordersList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(brokerLessorOrderIds)) {

                ordersList = ordersService.getObjectsByIds(brokerLessorOrderIds);

            }

            BigDecimal income = new BigDecimal("0");

            List<BigDecimal> totalPrice = MyListUtil.getDistinctList(Orders.class.getDeclaredField("price"), ordersList);

            log.info("total price size is :" + totalPrice.size());

            for (BigDecimal price : totalPrice) {

                income = income.add(price);

            }

            log.info("income is :" + income);

            Map<String, Object> paramList = DynamicUtil.getConstantListParam("broker", Long.toString(mid), null,
                    null,
                    null,
                    null, null, null, null, false);
            log.info(" paramList size =  " + paramList.size());

            List<Long> constantIdList = constantService.getIdsByDynamicCondition(Constant.class, paramList, start, size);

            log.info("constantIdList size is :" + constantIdList.size());

            String dividedIntoProportions = "0";

            if (CollectionUtils.isNotEmpty(constantIdList)) {


                Constant constant = constantService.getObjectById(constantIdList.get(0));

                dividedIntoProportions = constant.getValue();

                log.info("divided into proportions is ；" + dividedIntoProportions);

            }

            income = manager.getIncome();
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("next", next);
            model.addAttribute("userList", userList);
            model.addAttribute("income", income);
            model.addAttribute("totalUser", totalUser);
            model.addAttribute("dividedIntoProportions", dividedIntoProportions);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/withdraw/json/brokerUserList";
    }


    /**
     * 经纪人提现
     *
     * @param request
     * @param response
     * @param model
     * @param brokerId          经纪人ID
     * @param bankCardNumber    银行卡号
     * @param issuingBank       发卡银行
     * @param bankCardOwnerName 持卡人姓名
     * @param withdrawalAmount
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/broker/withdraw", method = RequestMethod.POST)
    public String brokerWithdraw(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Long brokerId, String bankCardNumber, String issuingBank, String bankCardOwnerName, BigDecimal withdrawalAmount)
            throws Exception {

        log.info("url is : /a/u/broker/withdraw?brokerId" + brokerId + "&bankCardNumber=" + bankCardNumber + "&issuingBank=" + issuingBank + "&bankCardOwnerName=" + bankCardOwnerName + "&withdrawalAmount=" + withdrawalAmount);

        if (DataUtils.isNullOrEmpty(brokerId)) {

            log.info("broker id is :" + brokerId);

            model.addAttribute("code", -40000);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(bankCardNumber)) {

            log.info("bankCardNumber is :" + bankCardNumber);

            model.addAttribute("code", -40001);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(issuingBank)) {

            log.info("issuingBank  is :" + issuingBank);

            model.addAttribute("code", -40002);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(withdrawalAmount)) {

            log.info("withdrawalAmount is :" + withdrawalAmount);

            model.addAttribute("code", -40004);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(bankCardOwnerName)) {

            log.info("bankCardOwnerName is :" + bankCardOwnerName);

            model.addAttribute("code", -40003);

            return "/common/success";

        }

        try {

            Manager manager = managerService.getObjectById(brokerId);

            if (DataUtils.isNullOrEmpty(manager)) {

                log.info("this broker is not exist");

                model.addAttribute("code", -40005);

                return "/common/success";

            }

            Withdraw withdraw = new Withdraw();

            withdraw.setStatus(Withdraw.PENDING);

            withdraw.setBrokerId(brokerId);

            withdraw.setBankCardNumber(bankCardNumber);

            withdraw.setIssuingBank(issuingBank);

            withdraw.setBankCardOwnerName(bankCardOwnerName);
            //判断余额是否足够
            if (manager.getIncome().compareTo(withdrawalAmount) >= 0) {
                withdraw.setWithdrawalAmount(withdrawalAmount);
            }else {
                model.addAttribute("code", -40007);
                return "common/success";
            }


            Long wid = withdrawService.insert(withdraw);
            manager.setIncome(manager.getIncome().subtract(withdrawalAmount));
            managerService.update(manager);
            log.info("wid is :" + wid);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 提现记录
     *
     * @param request
     * @param response
     * @param model
     * @param brokerId 经纪人ID
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/withdrawals/record", method = RequestMethod.GET)
    public String withdrawalsRecord(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long brokerId)
            throws Exception {

        log.info("url is : /a/u/withdrawals/record?brokerId" + brokerId);

        if (DataUtils.isNullOrEmpty(brokerId)) {

            log.info("broker id is :" + brokerId);

            model.addAttribute("code", -40000);

            return "/common/success";

        }

        try {

            Map<String, Object> recordParams = DynamicUtil.getBrokerRecord(brokerId);

            log.info("record params is :" + recordParams);

            List<Long> recordIds = withdrawService.getIdsByDynamicCondition(Withdraw.class, recordParams, 0, Integer.MAX_VALUE);

            log.info("record id size is :" + recordIds.size());

            List<Withdraw> withdrawList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(recordIds)) {

                withdrawList = withdrawService.getObjectsByIds(recordIds);

            }


            model.addAttribute("withdrawList", withdrawList);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/withdraw/json/withdrawListJson";
    }


    /**
     * 艺人管理列表（管理员页面）
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @param status
     * @param mobile
     * @param startAt
     * @param endAt
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/admin/search", method = RequestMethod.GET)
    public String getLessorForAdmin(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, Long mid, Integer status, String mobile, Long startAt, Long endAt)
            throws Exception {

        log.info("url is : /a/u/admin/search?mid" + mid + "&status=" + status + "&mobile=" + mobile + "&startAt=" + startAt + "&endAt=" + endAt);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;

        Integer total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> usersParams = DynamicUtil.getUserFromBrokerId(mid, null, null, status, mobile, startAt, endAt, false);

            log.info("usersParams is :" + usersParams);

            List<Long> uids = userService.getIdsByDynamicCondition(User.class, usersParams, start, size);

            log.info("uid is :" + uids);

            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(uids)) {

                userList = userService.getObjectsByIds(uids);

                if (userList.size() >= size) {

                    next = true;

                }

            }

            Integer totalUser = 0;

            Map<String, Object> countUserParam = DynamicUtil.getUserFromBrokerId(mid, null, null, status, mobile, startAt, endAt, true);

            log.info("countUserParam is :" + countUserParam);

            List<Long> countUids = userService.getIdsByDynamicCondition(User.class, usersParams, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isNotEmpty(countUids)) {

                total = countUids.size();

                totalUser = total;

                log.info("user total is :" + total);

            }

            log.info("countUids size is :" + countUids.size());

            BigDecimal income = new BigDecimal("0");

            // 分成比例
            String dividedIntoProportions = "0";

            if (DataUtils.isNotNullOrEmpty(mid)) {

                Map<String, Object> getLessorForMidParams = DynamicUtil.getLessorForMid(mid);

                log.info("get lessor for mid params is :" + getLessorForMidParams);

                List<Long> orderIds = ordersService.getIdsByDynamicCondition(Orders.class, getLessorForMidParams, 0, Integer.MAX_VALUE);

                log.info("order ids is :" + orderIds);

                List<Orders> ordersList = new ArrayList<>();

                if (CollectionUtils.isNotEmpty(orderIds)) {

                    ordersList = ordersService.getObjectsByIds(orderIds);

                }


                List<BigDecimal> totalPrice = MyListUtil.getDistinctList(Orders.class.getDeclaredField("price"), ordersList);

                log.info("total price size is :" + totalPrice.size());

                for (BigDecimal price : totalPrice) {

                    income = income.add(price);

                }

                log.info("income is :" + income);

                Map<String, Object> paramList = DynamicUtil.getConstantListParam("broker", Long.toString(mid), null,
                        null,
                        null,
                        null, null, null, null, false);
                log.info(" paramList size =  " + paramList.size());

                List<Long> constantIdList = constantService.getIdsByDynamicCondition(Constant.class, paramList, start, size);

                log.info("constantIdList size is :" + constantIdList.size());

                if (CollectionUtils.isNotEmpty(constantIdList)) {

                    Constant constant = constantService.getObjectById(constantIdList.get(0));

                    dividedIntoProportions = constant.getValue();

                    log.info("divided into proportions is ；" + dividedIntoProportions);

                }

            }


            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("next", next);
            model.addAttribute("userList", userList);
            model.addAttribute("income", income);
            model.addAttribute("totalUser", totalUser);
            model.addAttribute("dividedIntoProportions", dividedIntoProportions);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/withdraw/json/brokerUserList";
    }

    /**
     * 提现申请管理列表
     *
     * @param request
     * @param response
     * @param model
     * @param status
     * @param startAt
     * @param endAt
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/withdrawals/record/search", method = RequestMethod.GET)
    public String withdrawalsAdminRecord(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, Integer page,
                                         Integer size, Long brokerId, Integer status, Long startAt, Long endAt)
            throws Exception {

        log.info("url is : /a/u/withdrawals/record/search?brokerId" + brokerId + "&status=" + status + "&startAt=" + startAt + "&endAt=" + endAt);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        boolean next = false;

        Integer total = 0;

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> recordParams = DynamicUtil.getRecordForAdmin(brokerId, status, startAt, endAt, false);

            log.info("record params is ；" + recordParams);

            List<Long> recordIds = withdrawService.getIdsByDynamicCondition(Withdraw.class, recordParams, start, size);

            log.info("record id size is :" + recordIds.size());

            List<Withdraw> withdrawList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(recordIds)) {

                withdrawList = withdrawService.getObjectsByIds(recordIds);

                if (withdrawList.size() >= size) {

                    next = true;

                }

            }

            Map<String, Object> recordCountParams = DynamicUtil.getRecordForAdmin(brokerId, status, startAt, endAt, true);

            log.info("record count params is ；" + recordCountParams);

            List<Long> recordCountIds = withdrawService.getIdsByDynamicCondition(Withdraw.class, recordCountParams, start, size);

            log.info("record count id size is :" + recordIds.size());

            if (CollectionUtils.isNotEmpty(recordCountIds)) {

                total = recordCountIds.get(0).intValue();

            }

            log.info("total is :" + total);

            Integer totalApply = withdrawService.countWithdrawIds();

            log.info("total apply is ；" + totalApply);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("next", next);
            model.addAttribute("totalApply", totalApply);
            model.addAttribute("withdrawList", withdrawList);


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/withdraw/json/adminUserList";
    }

    /**
     * 提现申请管理详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/withdrawals/record/{id}", method = RequestMethod.GET)
    public String withdrawalsAdminRecordDetail(HttpServletRequest request,
                                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("url is : /a/u/withdrawals/record/" + id);

        if (DataUtils.isNullOrEmpty(id)) {

            log.info("id is :" + id);

            model.addAttribute("code", -1000);

            return "/common/success";

        }


        try {

            Withdraw withdraw = withdrawService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(withdraw)) {

                log.info("withdraw is null ");

                model.addAttribute("code", 2);

                return "/common/success";

            }

            model.addAttribute("code", 0);
            model.addAttribute("withdraw", withdraw);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/withdraw/json/withdrawDetailJson";
    }

    @RequestMapping(value = "/a/u/withdrawals/completed/{id}", method = RequestMethod.PUT)
    public String withdrawalsCompleted(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status)
            throws Exception {

        log.info("url is : /a/u/withdrawals/completed/" + id + "&status=" + status);

        if (DataUtils.isNullOrEmpty(id)) {

            log.info("id is :" + id);

            model.addAttribute("code", -1000);

            return "/common/success";

        }

        if (DataUtils.isNullOrEmpty(status)) {

            log.info("status is :" + status);

            model.addAttribute("code", -1000);

            return "/common/success";

        }


        try {

            Withdraw withdraw = withdrawService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(withdraw)) {

                log.info("withdraw is null ");

                model.addAttribute("code", 2);

                return "/common/success";

            }

            if (Withdraw.COMPLETED.equals(status)) {

                withdraw.setStatus(Withdraw.COMPLETED);

            } else {

                log.info("Illegal parameters");

                model.addAttribute("code", -1001);

                return "/common/success";

            }

            boolean b = withdrawService.update(withdraw);

            if (b) {

                log.info("update withdraw status is success");

            } else {

                log.info("update withdraw status is fail");

                model.addAttribute("code", -1);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


}
