package com.ptteng.rent.admin.utils;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.model.Withdraw;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.ast.Or;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author Dandandan
 * @date 2018/6/11
 */
public class DynamicUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getRecordForAdmin(Long brokerId, Integer status, Long startAt, Long endAt, boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(brokerId)) {

            params.put("broker_id", brokerId);

        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put("status", status);

        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {

            params.put("create_at & >= ", startAt);

        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {

            params.put("create_at &  <= ", endAt);

        }


        if (count) {

            params.put("@query", "count(id)");

        } else {

            params.put("@order", "create_at desc");

            params.put("@query", "id");

        }

        params.put("@table", "withdraw");

        return params;

    }

    /**
     * 获取经纪人提现记录列表
     *
     * @param brokerId
     * @return
     */
    public static Map<String, Object> getBrokerRecord(Long brokerId) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(brokerId)) {

            params.put("broker_id", brokerId);

        }

        params.put("status", Withdraw.COMPLETED);

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "withdraw");

        return params;

    }

    /**
     * 根据经纪人ID获取出租人正常完成订单
     *
     * @param mid
     * @return
     */
    public static Map<String, Object> getLessorForMid(Long mid) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(mid)) {

            params.put("mid", mid);

        }

        params.put("status", Orders.COMPLETE_THE_ORDER_NORMALLY);

        params.put("@order", "create_at desc");

        params.put("@query", "id");

        params.put("@table", "orders");

        return params;

    }

    /**
     * 艺人管理用户列表
     *
     * @param mid     经纪人ID
     * @param id      出租人ID
     * @param nick    出租人昵称
     * @param status  出租人状态
     * @param mobile  出租人手机号
     * @param startAt
     * @param endAt
     * @param count
     * @return
     */
    public static Map<String, Object> getUserFromBrokerId(Long mid, Long id, String nick, Integer status, String mobile, Long startAt, Long endAt, boolean count) {

        Map<String, Object> map = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(mid)) {

            map.put("recommender_id", mid);

        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {

            map.put("mobile & like ", "'%" + mobile + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(nick)) {

            map.put("nick & like ", "'%" + nick + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(id)) {

            map.put("id", id);

        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {

            map.put("create_at & >= ", startAt);

        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {

            map.put("create_at &  <= ", endAt);

        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            if (User.STATUS_ON.equals(status)) {

                map.put("status", status);

            } else {

                map.put("user_status", status);

            }

        }

        map.put("user_type", User.LESSOR);

        if (count) {

            map.put("@query", "count(id)");

        } else {

            map.put("@order", "create_at desc");

            map.put("@query", "id");

        }

        map.put("@table", "user");

        return map;

    }

    //用户列表
    public static Map<String, Object> getUserList(Integer sex, String positioning, Long id, String nick, Integer
            status, String mobile, Integer userType
            , String tag, Long startAt, Long endAt, boolean count) {

        Map<String, Object> map = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(sex)) {

            map.put("sex", sex);

        }

        if (DataUtils.isNotNullOrEmpty(positioning)) {

            map.put("positioning & like ", "'%" + positioning + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(tag)) {

            map.put("tag & like ", "'%" + tag + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(id)) {

            map.put("id", id);

        }

        if (DataUtils.isNotNullOrEmpty(userType)) {

            map.put("user_type", userType);

        }

        if (DataUtils.isNotNullOrEmpty(mobile)) {

            map.put("mobile & like ", "'%" + mobile + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(nick)) {

            map.put("nick & like ", "'%" + nick + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {

            map.put("create_at & >= ", startAt);

        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {

            map.put("create_at &  <= ", endAt);

        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            if (User.STATUS_ON.equals(status)) {

                map.put("status", status);

            } else {

                map.put("user_status", status);

            }

        }


        if (count) {

            map.put("@query", "count(id)");

        } else {

            map.put("@order", "create_at desc");

            map.put("@query", "id");

        }

        map.put("@table", "user");

        return map;

    }


    /**
     * 订单列表
     *
     * @param lessorId
     * @param positioning
     * @param lesseeId
     * @param status
     * @param startAt
     * @param endAt
     * @param count
     * @return
     */
    public static Map<String, Object> searchOrders(Long id, Long lessorId, String positioning, Long lesseeId, Integer
            status, Long startAt, Long endAt, boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(id)) {

            params.put("id", id);

        }

        if (DataUtils.isNotNullOrEmpty(lessorId)) {

            params.put("lessor_id", lessorId);

        }

        if (DataUtils.isNotNullOrEmpty(positioning)) {

            params.put("positioning & like ", "'%" + positioning + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(lesseeId)) {

            params.put("lessee_id", lesseeId);

        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            if (Orders.TO_BE_CONFIRMED.equals(status)) {

                params.put("status", Orders.LESSOR_IS_NOT_CONFIRMED);

            } else if (Orders.PROCESSING.equals(status)) {

                params.put("status & in ", "(" + "2,4" + ")");

            } else if (Orders.REFUNDING.equals(status)) {

                params.put("status & in ", "(" + "3,5,6,7,8,10" + ")");

            } else if (Orders.OVER.equals(status)) {

                params.put("status & in ", "(" + "9,11" + ")");

            } else if (Orders.IS_TERMINATED.equals(status)) {

                params.put("status", Orders.REFUNDED);

            }

        }else {

            params.put("status & in ", "(" + "1,2,3,4,5,6,7,8,9,10,11,12,13" + ")");

        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {

            params.put("create_at & >= ", startAt);

        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {

            params.put("create_at &  <= ", endAt);

        }

        if (count) {

            params.put("@query", "count(id)");

        } else {

            params.put("@order", "create_at desc");

            params.put("@query", "id");

        }

        params.put("@table", "orders");

        return params;

    }

    /**
     * 财务管理列表
     *
     * @param lessorId    出租人ID
     * @param positioning 订单定位
     * @param status      订单状态
     * @param startAt     订单开始时间
     * @param endAt       订单结束时间
     * @param sex         性别
     * @param count
     * @return
     */
    public static Map<String, Object> financeOrders(Long lessorId, String positioning, Integer status, Long
            startAt, Long endAt, Integer sex, boolean count) {

        Map<String, Object> params = new HashMap<>();

        Set<String> tables = new HashSet<>();

        tables.add("user user");

        tables.add("orders orders");

        params.put("user.id", "orders.lessor_id");

        if (DataUtils.isNotNullOrEmpty(lessorId)) {

            params.put("orders.lessor_id", lessorId);

        }

        if (DataUtils.isNotNullOrEmpty(positioning)) {

            params.put("orders.positioning & like ", "'%" + positioning + "%'");

        }

        if (DataUtils.isNotNullOrEmpty(sex)) {

            params.put("user.sex", sex);

        }

        if (DataUtils.isNotNullOrEmpty(status)) {

            if (Orders.TO_BE_CONFIRMED.equals(status)) {

                params.put("orders.status", Orders.LESSOR_IS_NOT_CONFIRMED);

            } else if (Orders.PROCESSING.equals(status)) {

                params.put("orders.status & in ", "(" + "2,4" + ")");

            } else if (Orders.REFUNDING.equals(status)) {

                params.put("orders.status & in ", "(" + "3,5,6,7,8,10" + ")");

            } else if (Orders.OVER.equals(status)) {

                params.put("orders.status & in ", "(" + "9,11" + ")");

            } else if (Orders.IS_TERMINATED.equals(status)) {

                params.put("orders.status", Orders.REFUNDED);

            }


        }else {

            params.put("orders.status & in ", "(" + "1,2,3,4,5,6,7,8,9,10,11,12,13" + ")");

        }

        if (DataUtils.isNotNullOrEmpty(startAt)) {

            params.put("orders.create_at & >= ", startAt);

        }

        if (DataUtils.isNotNullOrEmpty(endAt)) {

            params.put("orders.create_at &  <= ", endAt);

        }

        if (count) {

            params.put("@query", "count(orders.id)");

        } else {

            params.put("@order", "orders.create_at");

            params.put("@query", "orders.id");

        }

        String table = SQLUtil.convertTable(tables);

        params.put("@table", table);

        return params;

    }

    /**
     * 订单收入查询
     *
     * @param dateStarAt 订单开始时间
     * @param dateEndAt  订单结束时间
     * @param count
     * @return
     */
    public static Map<String, Object> incomeOrders(Long dateStarAt, Long dateEndAt, boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(dateStarAt)) {

            params.put("create_at & >= ", dateStarAt);

        }

        if (DataUtils.isNotNullOrEmpty(dateEndAt)) {

            params.put("create_at &  <= ", dateEndAt);

        }

        params.put("status & in ", "(" + "1,2,3,4,5,6,7,8,9,10,11,12,13" + ")");

        if (count) {

            params.put("@query", "count(id)");

        } else {

            params.put("@order", "create_at");

            params.put("@query", "id");

        }

        params.put("@table", "orders");

        return params;

    }

    public static Map<String, Object> getContentsQueryListParam(Integer[] type,
                                                                Integer status,
                                                                String title,
                                                                Long createBy,
                                                                Long createStartAt,
                                                                Long createEndAt,
                                                                Long publishStartAt,
                                                                Long publishEndAt, boolean isCount) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t != null) {
                        sb.append(t.toString());
                        sb.append(",");
                        i++;
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty(createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }


        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");

        return params;
    }

    public static Map<String, Object> getArticleListParam(String title, String url, String content, Integer
            status, Integer type, Integer bannerType) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");

        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put(" article.type", type);
        } else {
            params.put(" (article.type ", " 1 or type = 2)");
        }
        if (DataUtils.isNotNullOrEmpty(bannerType)) {

            params.put(" article.banner_type", bannerType);
        }
        if (DataUtils.isNotNullOrEmpty(content)) {

            params.put(" article.content & like", " '%" + content + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {

            params.put(" article.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(url)) {

            params.put(" article.url & like", " '%" + url + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put(" article.status ", status);
        }


        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    //查询常量列表
    public static Map<String, Object> getConstantListParam(String type, String name, String value,
                                                           String comments, Long startAt, Long endAt,
                                                           Long id, Long updateStartAt, Long updateEndAt,
                                                           boolean count) {


        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        log.info("start select from constant");
        tables.add("constant");

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("create_at &  <= ", endAt);
        }

        if (DataUtils.isNotNullOrEmpty(updateStartAt)) {
            params.put("update_at & >= ", updateStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(updateEndAt)) {
            params.put("update_at &  <= ", updateEndAt);
        }

        if (DataUtils.isNotNullOrEmpty(id)) {

            params.put("id", id);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    //查询用户消息关系表
    public static Map<String, Object> getUserMessage(Integer uid, Integer status, Long messageId, Integer type) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(messageId)) {
            params.put("message_id", messageId);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }
        params.put("@query", "id");
        params.put("@table", "userMessage");
        return params;
    }

    public static Map<String, Object> getMessageList(String title, Integer status, Long createBy, Long startAt,
                                                     Long endAt, Integer personType, boolean count) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("message");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("message.title & like", " '%" + title + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("message.status ", " '" + status + "'");
        }

        if (DataUtils.isNotNullOrEmpty(personType)) {
            params.put("message.person_type ", " '" + personType + "'");
        } else {
            params.put("message.person_type & in ", "(" + "1,2,3,4,5" + ")");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put("message.update_at & <= ", " '" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put("message.update_at & >= ", " '" + startAt + "'");
        }

        if (DataUtils.isNotNullOrEmpty(createBy)) {

            params.put("create_by", createBy);

        }

        if (count) {
            params.put("@query", " count(message.id) ");

        } else {
            params.put("@order", "  message.update_at desc  ");
            params.put("@query", " message.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getAllLessor() {

        Map<String, Object> params = new HashMap<>();


        params.put("user_type", User.LESSOR);


        params.put("@query", "id");

        params.put("@table", "user");


        return params;

    }


}


