package com.ptteng.rent.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.rent.admin.model.Article;
import com.ptteng.rent.admin.service.ArticleService;
import com.ptteng.rent.admin.service.ManagerService;
import com.ptteng.rent.admin.utils.AcademyArticleUtil;
import com.ptteng.rent.admin.utils.AcademyUserUtil;
import com.ptteng.rent.admin.utils.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {

    private static final Log log = LogFactory.getLog("article");

    private final String Img_Module_Common = "common";
    @Autowired
    private ArticleService articleService;

    @Autowired
    private ImgStorageUtil imgStorageUtil;

    @Autowired
    private ManagerService managerService;


    @Autowired
    private CookieUtil cookieUtil;

    // 图片上传
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) throws Exception {
        log.info("hello upload " + module);
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        log.info(file.getOriginalFilename());

        Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            log.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            log.info("new name is " + fileName);
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(null, module + "/" + fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
                    + " access url is " + url);
            tempPic.delete();
            log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            return "/common/success";
        }

    }


    /**
     * 单个查询展示内容
     *
     * @param request
     * @param response
     * @param model
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        log.info("get data : id= " + aid);
        try {
            if (aid == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(aid);
                log.info(article);
                if (article != null) {
                    log.info("get article data is " + article);
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -100000);
        }

        return "/com/ptteng/rent/admin/article/json/articleDetailJson";
    }

    /**
     * 修改内容
     *
     * @param request
     * @param response
     * @param model
     * @param article
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.PUT)
    public String updateArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Article article, @PathVariable Long aid, Integer gradeDept,
                                    Long subjectId, Long lessonId, Long periodId, Long taskId) throws Exception {

        log.info("update article : aid= " + aid);
        log.info(article);

        Article oArticle = articleService.getObjectById(aid);

        Integer bannerType = article.getBannerType();
        Integer bannerUrl = 1;

        try {

            Integer status = article.getStatus();
            Integer type = article.getType();

            if (status != 1 && status != 2) {
                model.addAttribute("code", -5040);
                return "common/success";
            }


            if (DataUtils.isNullOrEmpty(article.getImg())) {
                log.info(article.getImg());
                model.addAttribute("code", -5014);
                return "common/success";
            }

            // 当 banner 类型为链接
//            if (bannerType.equals(Article.hyperLink) && type != Article.help) {
//                String content = article.getContent();
//                if (DataUtils.isNullOrEmpty(content)) {
//                    model.addAttribute("code", -5049);
//                    return "common/success";
//                }
//            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            oArticle.setBannerType(article.getBannerType());
            oArticle.setImg(article.getImg());
            oArticle.setAppImg(article.getAppImg());


            oArticle.setUrl(article.getUrl());
            oArticle.setTitle(article.getTitle());
            oArticle.setContent(article.getContent());
            if (bannerType == bannerUrl) {
                oArticle.setContent(article.getUrl());
            }

            oArticle.setUpdateBy(Long.parseLong(userId));

            String contents = "";
            if (Article.help.equals(oArticle.getType())) {
                contents = article.getContent();
                contents = contents.replaceAll(" ", "&#160;");
                oArticle.setContent(contents);
            }

            article.setUpdateBy(Long.parseLong(userId));
            article.setId(aid);
            articleService.update(oArticle);

            model.addAttribute("code", 0);
            model.addAttribute("article", article);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + article.getId());
            model.addAttribute("code", -100000);
        }
        return "common/success";
    }

    /**
     * 发布或取消发布
     *
     * @param request
     * @param response
     * @param model
     * @param
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}/status/{status}", method = RequestMethod.PUT)
    public String updateArticleStatusJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long aid, @PathVariable Integer status) throws Exception {
        if (aid == null) {
            model.addAttribute("code", -1000);
            log.info("put article error aid is null");
            return "common/success";
        }
        Article article = articleService.getObjectById(aid);

        log.info("update article status : article id ,status = " + aid + " , " + status);
        if (status == 1 && article.getType() == 1) {
            int size = 10;
            int start = 0;
            List<Long> ids = null;
            Map<String, Object> param = DynamicUtil.getArticleListParam(null, null, null, 1, 1, null);
            ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);

            log.info("get article list ids is" + ids);
            List<Article> articleList = articleService.getObjectsByIds(ids);
            log.info(articleList.size());
            if (articleList.size() >= 9) {
                model.addAttribute("code", -9201);
                return "common/success";
            }
        }


        try {

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            article.setUpdateBy(Long.parseLong(userId));
            log.info("article is  " + article);
            if (Article.Status_Unpublished.equals(status)) {
                log.info("change status4");
                Long time = System.currentTimeMillis();
                article.setStatus(Article.Status_Unpublished);//取消发布
                article.setPublishat(time);
            } else {
                log.info("update status");

                article.setStatus(Article.Status_Published);//发布内容

            }


            articleService.update(article);

            model.addAttribute("code", 0);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + aid);
            model.addAttribute("code", -100000);

        }

        return "common/success";
    }

    /**
     * 添加内容
     *
     * @param request
     * @param response
     * @param model
     * @param article
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article", method = RequestMethod.POST)
    public String addArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Article article) throws Exception {

        log.info("update article : article id");
        Integer returnCode = AcademyArticleUtil.paramsLegal(article);
        if (0 != returnCode) {
            model.addAttribute("code", returnCode);
            return "common/success";
        }

        try {

            Integer returnCode2 = AcademyArticleUtil.paramsCheckWhenArticleTypeIsBanner(article);
            if (0 != returnCode2) {
                model.addAttribute("code", returnCode);
                return "common/success";
            }

            AcademyArticleUtil.whenArticleTypeIsHelp(article);

            Long userIdLongValue = AcademyUserUtil.getUserIdLongValue(request);
            article.setCreateBy(userIdLongValue);
            article.setUpdateBy(userIdLongValue);
            article.setOrderBy(getMaxSort());
            article.setId(null);
            article.setStatus(Article.Status_Published);
            article.setPublishat(System.currentTimeMillis());

            Long aid = articleService.insert(article);
            log.info(aid);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add article error ");
            model.addAttribute("code", -100000);
        }
        return "common/success";
    }

    private Integer getMaxSort() throws ServiceException, ServiceDaoException {
        Map<String, Object> param = DynamicUtil.getArticleListParam
                (null, null, null, null, null, null);
        List<Long> maxs = this.articleService.getIdsByDynamicCondition(
                Article.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            log.info(" maxID = " + maxID);
            max = this.articleService.getObjectById(maxID).getOrderBy();
            if (null == max) {
                max = 0;
            }
            log.info("quiz max order is " + max);
        }
        return max + 10;
    }

    /**
     * 资讯排序
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Article> articleList = articleService.getObjectsByIds(ids);

            int index = 0;
            for (Article article : articleList) {
                article.setOrderBy(index);
                index = index + 10;
            }
            this.articleService.updateList(articleList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bookUnit error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 删除内容
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{id}", method = RequestMethod.DELETE)
    public String deleteArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete article : id= " + id);
        try {
            articleService.delete(id);

            log.info("add article success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete article error,id is  " + id);
            model.addAttribute("code", -100000);

        }

        return "common/success";
    }

    /**
     * 条件查询内容
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/list", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 String title, String url, String content, Integer status, Integer type, Integer bannerType)
            throws Exception {
        log.info("/web/a/article/list ,page is:" + page + ",size is" + size + ",content is" + content + ", type" + type);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        try {

//			if(startAt == null && endAt == null && type == null && createBy == null && status == null){
//				ids = articleService.getArticleIds(start, size);
//				total=articleService.countArticleIds();
//				log.info("===============================================1"+ids + "=====" + total);
//			} else {
            Map<String, Object> param = DynamicUtil.getArticleListParam(title, url, content, status, type, bannerType);
            log.info("        param is    " + param);
//				Map<String, Object> countparam = DynamicUtil.getListParam(startAt, endAt, type, createBy, source, status, true);
            log.info("pageList : page= " + start + " , size=" + size);
            ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
            count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("===============================================2" + ids + "=====" + total);
//			}

            log.info("get article list ids is" + ids);
            List<Article> articleList = articleService.getObjectsByIds(ids);
            model.addAttribute("articleList", articleList);

            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {

                next = true;
            }
            model.addAttribute("next", next);
            log.info("next is : " + next);

            Integer totalPage = 1;
            if (total > 0) {

                totalPage = (total - 1) / size + 1;
                log.info("totalPage is : " + totalPage);
            }

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/com/ptteng/rent/admin/article/json/articleMultiJson";
    }

    /**
     * 根据type查找已发布内容
     *
     * @param page
     * @param size
     * @param type
     * @return
     * @throws Exception
     */
    public List<Article> getArticleListByType(Integer page, Integer size, Integer type) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        List<Long> ids = articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Published, start, size);
        log.info("get countArticleIdsByTypeAndStatusOrderByPublishat size is " + ids);


        List<Article> articleList = articleService.getObjectsByIds(ids);
        log.info("get article data is " + articleList);


        return articleList;
    }
}

