/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.rent.admin.model.RoleModule;
import com.ptteng.rent.admin.service.RoleModuleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RoleModuleServiceImpl
extends BaseDaoServiceImpl
implements RoleModuleService {
    private static final Log log = LogFactory.getLog(RoleModuleServiceImpl.class);
    @Autowired
    private Dao dao;

    public Long insert(RoleModule roleModule) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + roleModule));
        if (roleModule == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        roleModule.setCreateAt(Long.valueOf(currentTimeMillis));
        roleModule.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)roleModule);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + roleModule));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RoleModule> insertList(List<RoleModule> roleModuleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (roleModuleList == null ? "null" : Integer.valueOf(roleModuleList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(roleModuleList)) {
            return new ArrayList<RoleModule>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RoleModule roleModule : roleModuleList) {
            roleModule.setCreateAt(Long.valueOf(currentTimeMillis));
            roleModule.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(roleModuleList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + roleModuleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RoleModule.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RoleModule roleModule) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (roleModule == null ? "null" : roleModule.getId())));
        boolean result = false;
        if (roleModule == null) {
            return true;
        }
        roleModule.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)roleModule);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + roleModule));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + roleModule));
        }
        return result;
    }

    public boolean updateList(List<RoleModule> roleModuleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (roleModuleList == null ? "null" : Integer.valueOf(roleModuleList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(roleModuleList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RoleModule roleModule : roleModuleList) {
            roleModule.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(roleModuleList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + roleModuleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + roleModuleList.size()));
        return result;
    }

    public RoleModule getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RoleModule roleModule = null;
        if (id == null) {
            return roleModule;
        }
        try {
            roleModule = (RoleModule)this.dao.get(RoleModule.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return roleModule;
    }

    public List<RoleModule> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List roleModule = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RoleModule>();
        }
        try {
            roleModule = this.dao.getList(RoleModule.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (roleModule == null ? "null" : Integer.valueOf(roleModule.size()))));
        return roleModule;
    }

    public List<Long> getRoleModuleIdsByRid(Long rid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by rid,start,limit  : " + rid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRoleModuleIdsByRid", new Object[]{rid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by rid,start,limit)  : " + rid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getRoleModuleIdsByMid(Long mid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by mid,start,limit  : " + mid + " , " + start + " , " + limit));
        }
        log.info((Object)" mid iii");
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRoleModuleIdsByMid", new Object[]{mid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by rid,start,limit)  : " + mid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRoleModuleIdsByRid(Long rid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by rid  : " + rid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRoleModuleIdsByRid", new Object[]{rid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by rid)  : " + rid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getRoleModuleIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRoleModuleIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRoleModuleIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRoleModuleIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRoleModuleIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

