/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.pet.orderspush.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.pet.common.model.Message;
import com.ptteng.pet.common.service.MessageService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class MessageEtl {
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 30000L;
    private static final Log log = LogFactory.getLog((String)"autoScan");
    private MessageService messageService;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"etl is start!");
                    List<Message> messages = this.getMessages();
                    log.info((Object)("======" + messages));
                    if (CollectionUtils.isEmpty(messages)) {
                        log.info((Object)"messages etl not get any id ,sleep 30000 ms ");
                        Thread.sleep(30000L);
                    }
                    this.processOrder(messages);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(30000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Message> getMessages() {
        log.info((Object)"look here!!!!");
        List<Object> messages = new ArrayList<Message>();
        Long current = System.currentTimeMillis();
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("type", Message.TYPE_AFTER);
        conditions.put("status", Message.STATUS_AFTER);
        conditions.put("push_at & <=", current);
        conditions.put("@query", "id");
        conditions.put("@order", "create_at desc");
        conditions.put("@table", " message ");
        Long now = System.currentTimeMillis();
        try {
            List ids = this.messageService.getIdsByDynamicCondition(Message.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                log.info((Object)"not ger any process message ");
            } else {
                messages = this.messageService.getObjectsByIds(ids);
                log.info((Object)("get process messages is " + messages.size()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return messages;
    }

    private void processOrder(List<Message> messages) throws ServiceException, ServiceDaoException, InterruptedException, IOException {
        log.info((Object)"hello world!!!");
        if (CollectionUtils.isEmpty(messages)) {
            log.info((Object)"no query messages ");
            return;
        }
        log.info((Object)(this.interval + " will query messages size is " + messages.size()));
        for (Message message : messages) {
            Long id = message.getId();
            log.info((Object)("push push push message id is :" + id));
            message.setType(Message.TYPE_NOW);
            message.setStatus(Message.STATUS_NOW);
        }
        this.messageService.updateList(messages);
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }
}

