-- ----------------------------
-- Table structure for `book`
-- ----------------------------
-- DROP TABLE IF EXISTS `book`;
CREATE TABLE `book` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `press` varchar(1000)   ,  
    `grade` int(10)   ,
    `img` varchar(100)   ,  
    `sort` int(10)   ,
    `study_count` int(10)   ,
    `favorite_count` int(10)   ,
    `period_count` int(10)   ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `lesson`
-- ----------------------------
-- DROP TABLE IF EXISTS `lesson`;
CREATE TABLE `lesson` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `recommend` int(10)   ,
    `recommend_img` varchat(100)   ,
    `subject` int(10)    ,
    `img` varchar(100)   ,  
    `sort` int(10)    ,
    `study_count` int(10)    ,
    `favorite_count` int(10)    ,
    `period_count` int(10)    ,
    `paper_count` int(10)    ,
    `locked` int(10)    ,
    `collaborate_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `collaborate`
-- ----------------------------
-- DROP TABLE IF EXISTS `collaborate`;
CREATE TABLE `collaborate` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `img` varchar(100)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `paper`
-- ----------------------------
-- DROP TABLE IF EXISTS `paper`;
CREATE TABLE `paper` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `url` varchar(100)   ,  
    `count` int(10)    ,
    `price` varchar(100)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `period`
-- ----------------------------
-- DROP TABLE IF EXISTS `period`;
CREATE TABLE `period` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,
    `level` int(10)    ,
    `img` varchar(100)   ,  
    `sort` int(10)    ,
    `favorite_count` int(10)    ,
    `task_count` int(10)    ,
    `locked` int(10)    ,
    `lesson_id` bigint NOT NULL  ,  
    `paper_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `task`
-- ----------------------------
-- DROP TABLE IF EXISTS `task`;
CREATE TABLE `task` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `level` int(10)    ,
    `img` varchar(100)   ,  
    `hint_content` varchar(100)   ,  
    `hint_type` int(10)    ,
    `sort` int(10)    ,
    `unit_count` int(10)    ,
    `period_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `unit`
-- ----------------------------
-- DROP TABLE IF EXISTS `unit`;
CREATE TABLE `unit` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(1000)   ,  
    `introduce` varchar(5000)   ,  
    `type` int(10)    ,
    `link` varchar(100)   ,  
    `sort` int(10)    ,
    `length` int(10)    ,
    `task_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `progress`
-- ----------------------------
-- DROP TABLE IF EXISTS `progress`;
CREATE TABLE `progress` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `target_id` bigint NOT NULL  ,  
    `type` int(10)    ,
    `status` int(10)    ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_task_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_task_relation`;
CREATE TABLE `user_task_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `progress` bigint NOT NULL  ,  
    `period_id` bigint NOT NULL  ,  
    `lesson_id` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_favorite_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_favorite_relation`;
CREATE TABLE `user_favorite_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `target_id` bigint NOT NULL  ,  
    `type` int(10)    ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `locks`
-- ----------------------------
-- DROP TABLE IF EXISTS `locks`;
CREATE TABLE `locks` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `user_id` bigint NOT NULL  ,  
    `target_id` bigint NOT NULL  ,  
    `type` int(10)    ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_openid_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_openid_relation`;
CREATE TABLE `user_openid_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `openid` varchar(50) NOT NULL  ,  
    `type` varchar(20) NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `pwd` varchar(300) NOT NULL  ,
    `mobile` varchar(20) NOT NULL  ,
    `name` varchar(100)   ,
    `img` varchar (300)   ,
    `grade` int(10)    ,
    `term` int (10)   ,
    `learn_time` int(10)    ,
    `learn_score` int(10)    ,
    `learn_buy` int(10)    ,
    `score` float NOT NULL  ,  
    `register_at` bigint NOT NULL  ,  
    `last_login_at` bigint NOT NULL  ,  
    `status` bigint NOT NULL  ,  
    `wrong_count` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





