/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.pet.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.pet.admin.model.Opinion;
import com.ptteng.pet.admin.service.OpinionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpinionServiceImpl
extends BaseDaoServiceImpl
implements OpinionService {
    private static final Log log = LogFactory.getLog(OpinionServiceImpl.class);

    public Long insert(Opinion opinion) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + opinion));
        if (opinion == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        opinion.setCreateAt(Long.valueOf(currentTimeMillis));
        opinion.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)opinion);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + opinion));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Opinion> insertList(List<Opinion> opinionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (opinionList == null ? "null" : Integer.valueOf(opinionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(opinionList)) {
            return new ArrayList<Opinion>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Opinion opinion : opinionList) {
            opinion.setCreateAt(Long.valueOf(currentTimeMillis));
            opinion.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(opinionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + opinionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Opinion.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Opinion opinion) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (opinion == null ? "null" : opinion.getId())));
        boolean result = false;
        if (opinion == null) {
            return true;
        }
        opinion.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)opinion);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + opinion));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + opinion));
        }
        return result;
    }

    public boolean updateList(List<Opinion> opinionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (opinionList == null ? "null" : Integer.valueOf(opinionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(opinionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Opinion opinion : opinionList) {
            opinion.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(opinionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + opinionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + opinionList.size()));
        return result;
    }

    public Opinion getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Opinion opinion = null;
        if (id == null) {
            return opinion;
        }
        try {
            opinion = (Opinion)this.dao.get(Opinion.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return opinion;
    }

    public List<Opinion> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List opinion = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Opinion>();
        }
        try {
            opinion = this.dao.getList(Opinion.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (opinion == null ? "null" : Integer.valueOf(opinion.size()))));
        return opinion;
    }

    public List<Long> getOpinionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOpinionIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOpinionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOpinionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOpinionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

