/**
 *
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.WorkerLocation;
import com.ptteng.micro.mall.service.WorkerLocationService;

import java.util.List;

public class WorkerLocationSCAClient implements WorkerLocationService {

    private WorkerLocationService workerLocationService;

    public WorkerLocationService getWorkerLocationService() {
        return workerLocationService;
    }

    public void setWorkerLocationService(WorkerLocationService workerLocationService) {
        this.workerLocationService = workerLocationService;
    }

    @Override
    public boolean removeLocation(Long id) throws Exception {
        return workerLocationService.removeLocation(id);
    }

    @Override
    public boolean upsertLocation(WorkerLocation workLocation) throws ServiceException, ServiceDaoException {
        return workerLocationService.upsertLocation(workLocation);
    }

    @Override
    public List<WorkerLocation> getNear(Double x, Double y, Long distance, Integer limit) throws ServiceException, ServiceDaoException {
        return workerLocationService.getNear(x, y, distance, limit);
    }

    @Override
    public List<WorkerLocation> getWorksByLocationByConditions(Double latitude, Double longitude, Long distance,Integer workStatus, Integer verifiedStatus, Integer depositStatus, Double averageEvaluation, Integer start, Integer limit) throws ServiceDaoException, ServiceException {
        return workerLocationService.getWorksByLocationByConditions(latitude, longitude, distance, workStatus, verifiedStatus, depositStatus, averageEvaluation, start, limit);
    }
}
