/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.StockOutOrder;
import com.ptteng.micro.mall.service.StockOutOrderService;

import java.util.List;
import java.util.Map;

public class StockOutOrderSCAClient implements StockOutOrderService {

    private StockOutOrderService stockOutOrderService;

	public StockOutOrderService getStockOutOrderService() {
		return stockOutOrderService;
	}
	
	
	public void setStockOutOrderService(StockOutOrderService stockOutOrderService) {
		this.stockOutOrderService =stockOutOrderService;
	}
	
	
			   
		@Override
		public Long insert(StockOutOrder stockOutOrder)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.insert(stockOutOrder);
		          
		
		}	
		  
    	   
		@Override
		public List<StockOutOrder> insertList(List<StockOutOrder> stockOutOrderList)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.insertList(stockOutOrderList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(StockOutOrder stockOutOrder)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.update(stockOutOrder);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<StockOutOrder> stockOutOrderList)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.updateList(stockOutOrderList);
		          
		
		}	
		  
    	   
		@Override
		public StockOutOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<StockOutOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getStockOutOrderIdByPurchaseNo(String purchaseNo)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.getStockOutOrderIdByPurchaseNo(purchaseNo);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockOutOrderIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.getStockOutOrderIdsByMerchantId(merchantId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockOutOrderIdsByMerchantIdAndStatus(Long merchantId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.getStockOutOrderIdsByMerchantIdAndStatus(merchantId,status,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockOutOrderIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.countStockOutOrderIdsByMerchantId(merchantId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockOutOrderIdsByMerchantIdAndStatus(Long merchantId,Integer status)throws ServiceException, ServiceDaoException{
		
		return stockOutOrderService.countStockOutOrderIdsByMerchantIdAndStatus(merchantId,status);
	
	
	}
	
		
	
		@Override
	public List<Long> getStockOutOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOutOrderService.getStockOutOrderIds(start, limit);
	}

	@Override
	public Integer countStockOutOrderIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOutOrderService.countStockOutOrderIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOutOrderService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOutOrderService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   stockOutOrderService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.stockOutOrderService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.stockOutOrderService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

