/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.StockOrderPrint;
import com.ptteng.micro.mall.service.StockOrderPrintService;

import java.util.List;
import java.util.Map;

public class StockOrderPrintSCAClient implements StockOrderPrintService {

    private StockOrderPrintService stockOrderPrintService;

	public StockOrderPrintService getStockOrderPrintService() {
		return stockOrderPrintService;
	}
	
	
	public void setStockOrderPrintService(StockOrderPrintService stockOrderPrintService) {
		this.stockOrderPrintService =stockOrderPrintService;
	}
	
	
			   
		@Override
		public Long insert(StockOrderPrint stockOrderPrint)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.insert(stockOrderPrint);
		          
		
		}	
		  
    	   
		@Override
		public List<StockOrderPrint> insertList(List<StockOrderPrint> stockOrderPrintList)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.insertList(stockOrderPrintList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(StockOrderPrint stockOrderPrint)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.update(stockOrderPrint);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<StockOrderPrint> stockOrderPrintList)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.updateList(stockOrderPrintList);
		          
		
		}	
		  
    	   
		@Override
		public StockOrderPrint getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<StockOrderPrint> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockOrderPrintIdsByMerchantIdAndStatus(Long merchantId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.getStockOrderPrintIdsByMerchantIdAndStatus(merchantId,status,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockOrderPrintIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.getStockOrderPrintIdsByMerchantId(merchantId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getStockOrderPrintIdByMerchantIdAndStockOrderIdAndOrderType(Long merchantId,Long stockOrderId,Integer orderType)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.getStockOrderPrintIdByMerchantIdAndStockOrderIdAndOrderType(merchantId,stockOrderId,orderType);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockOrderPrintIdsByMerchantIdOrderByCreateAt(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.getStockOrderPrintIdsByMerchantIdOrderByCreateAt(merchantId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockOrderPrintIdsByMerchantIdAndStatus(Long merchantId,Integer status)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.countStockOrderPrintIdsByMerchantIdAndStatus(merchantId,status);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockOrderPrintIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.countStockOrderPrintIdsByMerchantId(merchantId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockOrderPrintIdsByMerchantIdOrderByCreateAt(Long merchantId)throws ServiceException, ServiceDaoException{
		
		return stockOrderPrintService.countStockOrderPrintIdsByMerchantIdOrderByCreateAt(merchantId);
	
	
	}
	
		
	
		@Override
	public List<Long> getStockOrderPrintIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOrderPrintService.getStockOrderPrintIds(start, limit);
	}

	@Override
	public Integer countStockOrderPrintIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOrderPrintService.countStockOrderPrintIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOrderPrintService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockOrderPrintService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   stockOrderPrintService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.stockOrderPrintService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.stockOrderPrintService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

