/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import java.util.List;
import java.util.Map;

import com.ptteng.micro.mall.model.Property;
import com.ptteng.micro.mall.service.PropertyService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class PropertySCAClient implements PropertyService {

    private PropertyService propertyService;

	public PropertyService getPropertyService() {
		return propertyService;
	}
	
	
	public void setPropertyService(PropertyService propertyService) {
		this.propertyService =propertyService;
	}
	
	
			   
		@Override
		public Long insert(Property property)throws ServiceException, ServiceDaoException{
		
		return propertyService.insert(property);
		          
		
		}	
		  
    	   
		@Override
		public List<Property> insertList(List<Property> propertyList)throws ServiceException, ServiceDaoException{
		
		return propertyService.insertList(propertyList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return propertyService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Property property)throws ServiceException, ServiceDaoException{
		
		return propertyService.update(property);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Property> propertyList)throws ServiceException, ServiceDaoException{
		
		return propertyService.updateList(propertyList);
		          
		
		}	
		  
    	   
		@Override
		public Property getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return propertyService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Property> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return propertyService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPropertyIdsByClassifyIdAndStatus(Long classifyId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return propertyService.getPropertyIdsByClassifyIdAndStatus(classifyId,status,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPropertyIdsByClassifyIdAndStatus(Long classifyId,Integer status)throws ServiceException, ServiceDaoException{
		
		return propertyService.countPropertyIdsByClassifyIdAndStatus(classifyId,status);
	
	
	}
	
		
	
		@Override
	public List<Long> getPropertyIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return propertyService.getPropertyIds(start, limit);
	}

	@Override
	public Integer countPropertyIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return propertyService.countPropertyIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return propertyService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return propertyService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   propertyService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.propertyService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public Object getMapListByDynamicCondition(Class clz,
											   Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.propertyService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}

}

